<?php
if ( ! function_exists( 'elearning_school_setup' ) ) :
function elearning_school_setup() {

	add_theme_support( "woocommerce" );	

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	add_theme_support( "responsive-embeds" );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );
	
	
	add_theme_support( 'custom-header' );
	
	//Add selective refresh for sidebar widget
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary_menu' => esc_html__( 'Primary Menu', 'elearning-school' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	
	/*
	 * Enable support for custom logo.
	 */
	add_theme_support('custom-logo');

	// -- Disable Custom Colors
	add_theme_support( 'disable-custom-colors' );
		
	// Gutenberg wide images.
	add_theme_support( 'align-wide' );
		
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css' ) );
	
	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'elearning_school_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	load_theme_textdomain( 'elearning-school', get_stylesheet_directory() . '/languages' );
}
endif;
add_action( 'after_setup_theme', 'elearning_school_setup' );

/*
 * Enable support for Post Formats.
 *
 * See: https://codex.wordpress.org/Post_Formats
*/
add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function elearning_school_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'elearning_school_content_width', 1170 );
}
add_action( 'after_setup_theme', 'elearning_school_content_width', 0 );

/**
 * Change number or products per row to 3
 */
add_filter('loop_shop_columns', 'elearning_school_loop_columns', 999);
if (!function_exists('elearning_school_loop_columns')) {
	function elearning_school_loop_columns() {
		return 3; // 3 products per row
	}
}

function elearning_school_customize_remove_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );
    
}
add_action( 'customize_register', 'elearning_school_customize_remove_register', 11 );

function elearning_school_text_domain_setup() {

/**
 * Get Started.
 */
require( get_template_directory() . '/inc/started/main.php');
/**
 * Customizer additions.
 */
 require_once get_template_directory() . '/inc/customizer.php';
}

add_action('after_setup_theme', 'elearning_school_text_domain_setup');

/**
 * Admin notice function.
 */
require_once get_template_directory() . '/inc/admin-notice/admin.php';

/**
 * All Styles & Scripts.
 */
require_once get_template_directory() . '/inc/enqueue.php';

/**
 * Implement the Custom Header feature.
 */
require_once get_template_directory() . '/inc/custom-header.php';

/**
 * Sidebar.
 */
require_once get_template_directory() . '/inc/sidebar/sidebar.php';

/**
 * Custom template tags for this theme.
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/extras.php';

/**
 * Load Jetpack compatibility file.
 */
require_once get_template_directory() . '/inc/jetpack.php';

/**
 * Load Web Font
 */
require_once get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
 * Load demo importer
 */
require_once get_template_directory() . '/inc/importer/config.php';

/**
 * Called all the Customize file.
 */
require( get_template_directory() . '/inc/customize/premium.php');

/* 
* Logo Resizer
*/
function elearning_school_logo_resizer_setting() {

    $elearning_school_theme_logo_size_css = '';
    $elearning_school_logo_resizer_setting = get_theme_mod('elearning_school_logo_resizer_setting');

	$elearning_school_theme_logo_size_css = '
		.custom-logo{
			height: '.esc_attr($elearning_school_logo_resizer_setting).'px !important;
			width: '.esc_attr($elearning_school_logo_resizer_setting).'px !important;
		}
	';
    wp_add_inline_style( 'elearning-school-style',$elearning_school_theme_logo_size_css );

}
add_action( 'wp_enqueue_scripts', 'elearning_school_logo_resizer_setting' );

/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('elearning_school_sticky_header')):
    function elearning_school_sticky_header()
    {
        $elearning_school_is_sticky = get_theme_mod('elearning_school_sticky_header_setting', false);

        if ($elearning_school_is_sticky == false):
            return 'not-sticky';
        else:
            return 'is-sticky-on';
        endif;
    }
endif;

function elearning_school_breadcrumb() {
    $separator = get_theme_mod( 'elearning_school_breadcrumb_separator', ' → ' );

    if (is_home()) {
        echo "<span>Home</span>";
    } else if (!is_home()) {
        echo '<a href="' . home_url() . '">Home</a>' . $separator;

        if (is_archive()) {
            if (is_category()) {
                echo "<span>";
                single_cat_title();
                echo "</span>";
            } elseif (is_tag()) {
                echo "<span>";
                single_tag_title();
                echo "</span>";
            } elseif (is_date()) {
                echo "<span>";
                echo get_the_date('F Y');
                echo "</span>";
            } elseif (is_author()) {
                echo '<span>Author: ';
                the_author();
                echo '</span>';
            } else {
                echo post_type_archive_title() . $separator;
            }
        } elseif (is_single()) {
            if ('product' === get_post_type()) {
                echo '<a href="' . get_permalink(wc_get_page_id('shop')) . '">Shop</a>' . $separator;
                echo "<span>";
                the_title();
                echo "</span>";
            } else {
                the_category(', ');
                echo $separator;
                echo "<span>";
                the_title();
                echo "</span>";
            }
        } elseif (is_page()) {
            echo "<span>";
            the_title();
            echo "</span>";
        } elseif (is_search()) {
            echo '<span>Search Results for: ' . get_search_query() . '</span>';
        } elseif (is_404()) {
            echo "<span>404</span>";
        } else {
            echo "<span>";
            the_title();
            echo "</span>";
        }
    }
}

function get_page_id_by_title($pagename){

    $args = array(
        'post_type' => 'page',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'title' => $pagename
    );
    $query = new WP_Query( $args );

    $page_id = '1';
    if (isset($query->post->ID)) {
        $page_id = $query->post->ID;
    }

    return $page_id;
}