<?php
/**
 * Ekta Directory Theme Customizer
 *
 * @package ekta_directory
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ekta_directory_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$ekta_directory_options = ekta_directory_theme_options();

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'ekta_directory_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'ekta_directory_customize_partial_blogdescription',
			)
		);
	}


    $wp_customize->add_setting('ekta_directory_theme_options[site_title_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['site_title_show'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[site_title_show]',
        array(
            'label' => esc_html__('Show Title & Tagline', 'ekta-directory'),
            'type' => 'Checkbox',
            'section' => 'title_tagline',

        )
    );


    $wp_customize->add_panel(
        'theme_options',
        array(
            'title' => esc_html__('Theme Options', 'ekta-directory'),
            'priority' => 2,
        )
    );



    /* Banner Section */

    $wp_customize->add_section(
        'banner_section',
        array(
            'title' => esc_html__( 'Banner Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );




	$wp_customize->add_setting('ekta_directory_theme_options[banner_title]',
	    array(
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control('banner_title',
	    array(
	        'label' => esc_html__('Title', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'banner_section',
	        'settings' => 'ekta_directory_theme_options[banner_title]',
	    )
	);


	$wp_customize->add_setting('ekta_directory_theme_options[banner_bg_image]',
	    array(
	        'type' => 'option',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'ekta_directory_theme_options[banner_bg_image]',
	        array(
	            'label' => esc_html__('Add Background Image', 'ekta-directory'),
	            'section' => 'banner_section',
	            'settings' => 'ekta_directory_theme_options[banner_bg_image]',
	        ))
	);





    $wp_customize->add_section(
        'listing_cat_section',
        array(
            'title' => esc_html__( 'Listing Category Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );

    $wp_customize->add_setting('ekta_directory_theme_options[listing_cat_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['listing_cat_show'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[listing_cat_show]',
        array(
            'label' => esc_html__('Show Listing Category Section?', 'ekta-directory'),
            'type' => 'Checkbox',
            'priority' => 1,
            'section' => 'listing_cat_section',

        )
    );

	$wp_customize->add_setting('ekta_directory_theme_options[listing_cat_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $ekta_directory_options['listing_cat_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('ekta_directory_theme_options[listing_cat_title]',
	    array(
	        'label' => esc_html__('Section Title', 'ekta-directory'),
	        'priority' => 1,
	        'section' => 'listing_cat_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('ekta_directory_theme_options[listing_cat_desc]',
	    array(
	        'default' => $ekta_directory_options['listing_cat_desc'],
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field'
	    )
	);

	$wp_customize->add_control('ekta_directory_theme_options[listing_cat_desc]',
	    array(
	        'label' => esc_html__(' Section Description', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'listing_cat_section',
	        'settings' => 'ekta_directory_theme_options[listing_cat_desc]',
	    )
	);
    $wp_customize->add_setting( 'ekta_directory_theme_options[cat_column]', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'ekta_directory_sanitize_radio',
        'default' => '1',
        'type' => 'option',
        ) );
    
        $wp_customize->add_control( 'ekta_directory_theme_options[cat_column]', array(
        'type' => 'radio',
        'section' => 'listing_cat_section', 
        'label' =>esc_attr( __('Catgories Layout', 'ekta-directory') ),
        'choices' => array(
            '1' => esc_attr( __('3 Column', 'ekta-directory') ),
            '2' => esc_attr( __('4 Column', 'ekta-directory') ),
        ),
        ) );

		$wp_customize->add_setting( 'ekta_directory_theme_options[cat_layout]', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'ekta_directory_sanitize_radio',
			'default' => 'withimage',
			'type' => 'option',
		) );

		$wp_customize->add_control( 'ekta_directory_theme_options[cat_layout]', array(
			'type' => 'radio',
			'section' => 'listing_cat_section', 
			'label' =>esc_attr( __('Catgories Design Layout', 'ekta-directory') ),
			'choices' => array(
				'withimage' => esc_attr( __('Category Image Layout', 'ekta-directory') ),
				'withicon' => esc_attr( __('Category Icon Layout', 'ekta-directory') ),
				
			),
			) );


    //radio box sanitization function
    function ekta_directory_sanitize_radio( $input, $setting ){

        //input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
        $input = sanitize_key($input);

        //get the list of possible radio box options
        $choices = $setting->manager->get_control( $setting->id )->choices;

        //return input if valid or return default option
        return ( array_key_exists( $input, $choices ) ? $input : $setting->default );

    }
    /* Listing Section */

    $wp_customize->add_section(
        'listing_item_section',
        array(
            'title' => esc_html__( 'Listing Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );


    $wp_customize->add_setting('ekta_directory_theme_options[listing_item_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['listing_item_show'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[listing_item_show]',
        array(
            'label' => esc_html__('Listings Section Options', 'ekta-directory'),
            'type' => 'Checkbox',
            'priority' => 1,
            'section' => 'listing_item_section',

        )
    );

	$wp_customize->add_setting('ekta_directory_theme_options[listing_item_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $ekta_directory_options['listing_item_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('ekta_directory_theme_options[listing_item_title]',
	    array(
	        'label' => esc_html__('Section Title', 'ekta-directory'),
	        'priority' => 1,
	        'section' => 'listing_item_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('ekta_directory_theme_options[listing_item_desc]',
	    array(
	        'default' => $ekta_directory_options['listing_item_desc'],
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field'
	    )
	);

	$wp_customize->add_control('ekta_directory_theme_options[listing_item_desc]',
	    array(
	        'label' => esc_html__(' Section Description', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'listing_item_section',
	        'settings' => 'ekta_directory_theme_options[listing_item_desc]',
	    )
	);

	$wp_customize->add_setting( 'ekta_directory_theme_options[listing_column]', array(
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'ekta_directory_sanitize_radio',
        'default' => '3column',
        'type' => 'option',
        ) );
    
        $wp_customize->add_control( 'ekta_directory_theme_options[listing_column]', array(
        'type' => 'radio',
        'section' => 'listing_item_section', 
        'label' =>esc_attr( __('Catgories Layout', 'ekta-directory') ),
        'choices' => array(
            '2column' => esc_attr( __('2 Column', 'ekta-directory') ),
            '3column' => esc_attr( __('3 Column', 'ekta-directory') ),
			'4column' => esc_attr( __('4 Column', 'ekta-directory') ),
        ),
        ) );


    /* CTA Section */

    $wp_customize->add_section(
        'cta_section',
        array(
            'title' => esc_html__( 'Call to Action Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );


    $wp_customize->add_setting('ekta_directory_theme_options[cta_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['cta_show'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[cta_show]',
        array(
            'label' => esc_html__('Show CTA Section', 'ekta-directory'),
            'type' => 'Checkbox',
            'priority' => 1,
            'section' => 'cta_section',

        )
    );
	$wp_customize->add_setting('ekta_directory_theme_options[cta_title]',
	    array(
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control('cta_title',
	    array(
	        'label' => esc_html__('Title', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'cta_section',
	        'settings' => 'ekta_directory_theme_options[cta_title]',
	    )
	);


	$wp_customize->add_setting('ekta_directory_theme_options[cta_button_txt]',
	    array(
	        'type' => 'option',
	        'default' => $ekta_directory_options['cta_button_txt'],
	        'sanitize_callback' => 'sanitize_text_field',
	    )
	);
	$wp_customize->add_control('ekta_directory_theme_options[cta_button_txt]',
	    array(
	        'label' => esc_html__('CTA Button Text', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'cta_section',
	        'settings' => 'ekta_directory_theme_options[cta_button_txt]',
	    )
	);
	$wp_customize->add_setting('ekta_directory_theme_options[cta_button_url]',
	    array(
	        'type' => 'option',
	        'default' => $ekta_directory_options['cta_button_url'],
	        'sanitize_callback' => 'ekta_directory_sanitize_url',
	    )
	);
	$wp_customize->add_control('ekta_directory_theme_options[cta_button_url]',
	    array(
	        'label' => esc_html__('CTA Button Link', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'cta_section',
	        'settings' => 'ekta_directory_theme_options[cta_button_url]',
	    )
	);


	$wp_customize->add_setting('ekta_directory_theme_options[cta_bg_image]',
	    array(
	        'type' => 'option',
	        'sanitize_callback' => 'esc_url_raw',
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'ekta_directory_theme_options[cta_bg_image]',
	        array(
	            'label' => esc_html__('Add Background Image', 'ekta-directory'),
	            'section' => 'cta_section',
	            'settings' => 'ekta_directory_theme_options[cta_bg_image]',
	        ))
	);






    /* Blog Section */

    $wp_customize->add_section(
        'blog_section',
        array(
            'title' => esc_html__( 'Blog Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );

    $wp_customize->add_setting('ekta_directory_theme_options[blog_show]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['blog_show'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[blog_show]',
        array(
            'label' => esc_html__('Show Blog Section', 'ekta-directory'),
            'type' => 'Checkbox',
            'priority' => 1,
            'section' => 'blog_section',

        )
    );
	$wp_customize->add_setting('ekta_directory_theme_options[blog_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $ekta_directory_options['blog_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('ekta_directory_theme_options[blog_title]',
	    array(
	        'label' => esc_html__('Section Title', 'ekta-directory'),
	        'priority' => 1,
	        'section' => 'blog_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('ekta_directory_theme_options[blog_desc]',
	    array(
	        'default' => $ekta_directory_options['blog_desc'],
	        'type' => 'option',
	        'sanitize_callback' => 'sanitize_text_field'
	    )
	);

	$wp_customize->add_control('ekta_directory_theme_options[blog_desc]',
	    array(
	        'label' => esc_html__('Blog Section Description', 'ekta-directory'),
	        'type' => 'text',
	        'section' => 'blog_section',
	        'settings' => 'ekta_directory_theme_options[blog_desc]',
	    )
	);

	$wp_customize->add_setting('ekta_directory_theme_options[blog_category]', array(
	    'default' => $ekta_directory_options['blog_category'],
	    'type' => 'option',
	    'sanitize_callback' => 'ekta_directory_sanitize_select',
	    'capability' => 'edit_theme_options',

	));

	$wp_customize->add_control(new ekta_directory_Dropdown_Customize_Control(
	    $wp_customize, 'ekta_directory_theme_options[blog_category]',
	    array(
	        'label' => esc_html__('Select Blog Category', 'ekta-directory'),
	        'section' => 'blog_section',
	        'choices' => ekta_directory_get_categories_select(),
	        'settings' => 'ekta_directory_theme_options[blog_category]',
	    )
	));

     function ekta_directory_sanitize_checkbox( $input ) {
        if ( true === $input ) {
            return 1;
         } else {
            return 0;
         }
    }

    /* Blog Section */

    $wp_customize->add_section(
        'prefooter_section',
        array(
            'title' => esc_html__( 'Prefooter Section','ekta-directory' ),
            'panel'=>'theme_options',
            'capability'=>'edit_theme_options',
        )
    );

    $wp_customize->add_setting('ekta_directory_theme_options[show_prefooter]',
        array(
            'type' => 'option',
            'default'        => true,
            'default' => $ekta_directory_options['show_prefooter'],
            'sanitize_callback' => 'ekta_directory_sanitize_checkbox',
        )
    );

    $wp_customize->add_control('ekta_directory_theme_options[show_prefooter]',
        array(
            'label' => esc_html__('Show Prefooter Section', 'ekta-directory'),
            'type' => 'Checkbox',
            'priority' => 1,
            'section' => 'prefooter_section',

        )
    );
}
add_action( 'customize_register', 'ekta_directory_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function ekta_directory_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function ekta_directory_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ekta_directory_customize_preview_js() {
	wp_enqueue_script( 'ekta-directory-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'ekta_directory_customize_preview_js' );
