<?php
/**
 * Add required and recommended plugins.
 *
 * @package Eightydays Lite
 */

add_action( 'tgmpa_register', 'eightydays_lite_register_required_plugins' );
add_filter( 'ocdi/register_plugins', 'eightydays_lite_register_ocdi_plugins' );

function eightydays_lite_register_required_plugins() {
	tgmpa( eightydays_lite_required_plugins(), [
		'id'          => 'eightydays-lite',
		'has_notices' => true,
	] );
}

function eightydays_lite_register_ocdi_plugins( $plugins ) {
	return array_merge( $plugins, eightydays_lite_required_plugins() );
}

/**
 * List of required plugins
 */
function eightydays_lite_required_plugins() {
	return [
		[
			'name' =>  'Jetpack',
			'slug' => 'jetpack',
		],
		[
			'name' =>  'Slim SEO',
			'slug' => 'slim-seo',
		],
		[
			'name' =>  'Falcon',
			'slug' => 'falcon',
		],
		[
			'name' =>  'One Click Demo Import',
			'slug' => 'one-click-demo-import',
		],
	];
}
