<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Edutechstar_btn_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {
		require_once get_template_directory() . '/upgrade-to-pro/section-pro.php';


		wp_enqueue_script( 'edutechstar-customize-controls', trailingslashit( get_template_directory_uri() ) . '/upgrade-to-pro/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'edutechstar-customize-controls', trailingslashit( get_template_directory_uri() ) . '/upgrade-to-pro/customize-controls.css' );

	}
	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		require_once get_template_directory() . '/upgrade-to-pro/section-pro.php';

		// Register custom section types.
		$manager->register_section_type( 'Edutechstar_Customize_btn_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Edutechstar_Customize_btn_Section_Pro(
				$manager,
				'edutechstar',
				array(
					'title'    => esc_html__( 'Know More Edutechstar', 'edutechstar' ),
					'pro_text' => esc_html__( 'Upgrade To Pro',         'edutechstar' ),
					'pro_url'  => 'https://weblizar.com/themes/edutechstar-premium/',
					'priority' => 0
				)
			)
		);
		
	}

	
}

// Doing this customizer thang!
Edutechstar_btn_Customize::get_instance();