<?php
/**
 * Template Name: WooCommerce Template
 *
 * This template is used to display WooCommerce pages.
 *
 * @package Eduna Online Course
 */

$eduna_online_course_column = is_active_sidebar('eduna-online-course-woocommerce-sidebar') ? 'col-lg-9' : 'col-12';

get_header();
?>
<div class="eduna-online-course-woocommerce-page eduna-online-course-page">
    <div class="container">
        <div class="row">
            <div class="<?php echo $eduna_online_course_column;?>">
                <!-- Main Content Area -->
                <main id="main" class="site-main">
                    <?php woocommerce_content(); ?>
                </main>
                <!-- End Main Content Area -->
            </div>
            <?php if (is_active_sidebar('eduna-online-course-woocommerce-sidebar')) : ?>
            <div class="col-lg-3 col-12">
                <!-- Sidebar -->
                <aside id="secondary" class="sidebar">               
                    <div class="widget-area">
                        <?php dynamic_sidebar('eduna-online-course-woocommerce-sidebar'); ?>
                    </div>
                </aside>
                <!-- End Sidebar -->
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
get_footer();
?>
