<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Eduna Online Course
 */
?>
<div class="<?php if(is_active_sidebar('sidebar')):?> col-lg-6 col-md-6 col-12 <?php else :?> col-lg-4 col-md-6 col-12 <?php endif;?>   eduna-online-course-masonry-item">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="eduna-online-course-blog__card">
			<?php if(has_post_thumbnail()) : ?>	
			<div class="eduna-online-course-blog__head">
				<div class="eduna-online-course-blog__img">
					<?php the_post_thumbnail('eduna-online-course-blog-thumb'); ?>
				</div>
			</div>
			<?php endif;?>
			<div class="eduna-online-course-blog__content">
				<ul class="eduna-online-course-blog__meta">
                    <li><?php echo get_the_date(); ?></li>
                    <li><?php echo get_comments_number_text(); ?></li>
                </ul>
				<h3 class="eduna-online-course-blog__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
			</div>
		</div>
	</article> <!-- #post-<?php the_ID(); ?> -->
</div>