<?php
add_action( 'init', 'eduna_online_course_kirki_customizer_setup' );

function eduna_online_course_kirki_customizer_setup() {


Kirki::add_config( 'my_theme_config', array(
    'capability' => 'edit_theme_options',
    'option_type' => 'theme_mod',
) );


new \Kirki\Panel(
	'eduna_online_course_panel_id',
	[
		'priority'    => 1,
		'title'       => esc_html__( 'Eduna Online Course: Theme Options', 'eduna-online-course' ),
		'description' => esc_html__( 'Theme Settings.', 'eduna-online-course' ),
	]
);


/* Topbar Settings */
new \Kirki\Section(
	'eduna_online_course_header',
	[
		'title'       => esc_html__( 'Header Settings', 'eduna-online-course' ),
		'description' => esc_html__( 'Customize Header Options.', 'eduna-online-course' ),
		'panel'       => 'eduna_online_course_panel_id',
		'priority'    => 160,
	]
);


/* Header Search Form */
new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'header_category_search',
		'label'       => esc_html__( 'Show Category Dropdown?', 'eduna-online-course' ),
		'section'     => 'eduna_online_course_header',
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'eduna-online-course' ),
			'off' => esc_html__( 'Disable', 'eduna-online-course' ),
		],
		'priority' => 3,
	]
);


new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'header_cart_option',
		'label'       => esc_html__( 'Show Header Cart?', 'eduna-online-course' ),
		'section'     => 'eduna_online_course_header',
		'default'     => 'off',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'eduna-online-course' ),
			'off' => esc_html__( 'Disable', 'eduna-online-course' ),
		],
		'priority' => 3,
	]
);

new \Kirki\Field\Text(
	[
		'settings' => 'header_login_btn_text',
		'label'    => esc_html__( 'Login Button Text', 'eduna-online-course' ),
		'section'  => 'eduna_online_course_header',
		'default'  => esc_html__( 'Dashboard', 'eduna-online-course' ),
		'priority' => 8,
	]
);

new \Kirki\Field\URL(
	[
		'settings' => 'header_login_btn_url',
		'label'    => esc_html__( 'Login Button URL', 'eduna-online-course' ),
		'section'  => 'eduna_online_course_header',
		'default'  => esc_html__( '#', 'eduna-online-course' ),
		'priority' => 5,
	]
);



/* Product Category Settings */
new \Kirki\Section(
	'eduna_online_course_page_breadcrumb',
	[
		'title'       => esc_html__( 'Breadcrumbs', 'eduna-online-course' ),
		'description' => esc_html__( 'Breadcrumbs Settings.', 'eduna-online-course' ),
		'panel'       => 'eduna_online_course_panel_id',
		'priority'    => 160,
	]
);

new \Kirki\Field\Checkbox(
	[
		'settings'    => 'eduna_online_course_page_bc',
		'label'       => esc_html__( 'Show page breadcrumb', 'eduna-online-course' ),
		'section'     => 'eduna_online_course_page_breadcrumb',
		'default'     => true,
	]
);

new \Kirki\Field\Checkbox(
	[
		'settings'    => 'eduna_online_course_archive_bc',
		'label'       => esc_html__( 'Show Archive breadcrumb', 'eduna-online-course' ),
		'section'     => 'eduna_online_course_page_breadcrumb',
		'default'     => true,
	]
);

new \Kirki\Field\Checkbox(
	[
		'settings'    => 'eduna_online_course_search_bc',
		'label'       => esc_html__( 'Show Search breadcrumb', 'eduna-online-course' ),
		'section'     => 'eduna_online_course_page_breadcrumb',
		'default'     => true,
	]
);

}