<div class="wrap eduna-admin-wrap">
    <h1><?php esc_html_e(' Welcome to Eduna Online Course! 🎉', 'eduna-online-course'); ?></h1>

    <p><?php esc_html_e(' Thank you for choosing the Eduna Online Course WordPress Theme! 🚀', 'eduna-online-course'); ?></p>
    <p>
        <?php esc_html_e('In the free version, you must manually install as per WordPress rules. It’s super easy — just follow 3 simple steps 😊.', 'eduna-online-course'); ?><br>
        <b><?php esc_html_e('Our pro version, the installation process is super easy — just one click!', 'eduna-online-course'); ?>
        </b>
    </p>
    <p>
    <a href="<?php echo esc_url( 'https://pencilwp.com/product/eduna-online-course' ); ?>" class="button button-secondary" target="_blank">
        <?php esc_html_e( 'Free Version', 'eduna-online-course' ); ?>
    </a>   
    <a href="<?php echo esc_url( 'https://demo.pencilwp.com/preview/eduna-wp/' ); ?>" class="button button-primary" target="_blank">
        <?php esc_html_e( 'View Premium Demo', 'eduna-online-course' ); ?>
    </a> 
    <a href="<?php echo esc_url( 'https://pencilwp.com/product/eduna-online-course-pro/' ); ?>" class="button button-primary eduna-btn-pro" target="_blank">
        <?php esc_html_e( 'Upgrade to Premium', 'eduna-online-course' ); ?>
    </a>
    </p>

    <h2 class="nav-tab-wrapper">
        <a href="#installation" class="nav-tab nav-tab-active"><?php esc_html_e('Installation Guide', 'eduna-online-course'); ?></a>
        <a href="#customization" class="nav-tab"><?php esc_html_e('Customization', 'eduna-online-course'); ?></a>
        <a href="#features" class="nav-tab"><?php esc_html_e('Free vs Pro Features', 'eduna-online-course'); ?></a>
        <a href="#documentation" class="nav-tab"><?php esc_html_e('Documentation', 'eduna-online-course'); ?></a>
    </h2>

    <div id="installation" class="tab-content">
       

        <table class="widefat">
            <thead>
                <tr>
                    <th><?php esc_html_e('Step', 'eduna-online-course'); ?></th>
                    <th><?php esc_html_e('Action', 'eduna-online-course'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><b><?php esc_html_e('Step 1:', 'eduna-online-course'); ?></b></td>
                   
                    <td>
                        <?php esc_html_e('You may encounter issues while bulk-installing plugins. Make sure all plugins are installed and activated.', 'eduna-online-course'); ?><br>
                        <a href="<?php echo esc_url(admin_url('themes.php?page=tgmpa-install-plugins')); ?>" target="_blank" class="button button-secondary btn-demo"><?php esc_html_e('Install Required Plugins', 'eduna-online-course'); ?></a>
                    </td>
                </tr>
                <tr>
                    <td><b><?php esc_html_e('Step 2:', 'eduna-online-course'); ?></b></td>
                    <td>
                        <?php esc_html_e('Once downloaded, unzip the file and save the [XML demo content single file] to your PC.', 'eduna-online-course'); ?><br>
                        <a href="https://demo.pencilwp.com/wp-free/eduna-online-course/demo-data/demo-data.zip" 
                        class="button button-secondary btn-demo" target="_blank">
                        <?php esc_html_e('Download Demo Content', 'eduna-online-course'); ?>
                        </a>
                    </td>
                </tr>

                <tr>
                    <td><b><?php esc_html_e('Step 3:', 'eduna-online-course'); ?></b></td>
                    <td>
                        <?php esc_html_e('Next, go to Demo Import page, then go to [Import Content] section, upload the XML file and click on [Continue & Import].', 'eduna-online-course'); ?><br>
                        <a href="<?php echo esc_url(admin_url('themes.php?page=one-click-demo-import')); ?>" target="_blank" class="button button-secondary  btn-demo">
                            <?php esc_html_e('Import Demo Content', 'eduna-online-course'); ?>
                        </a>
                    </td>

                </tr>
            </tbody>
        </table>
    </div>

    <div id="customization" class="tab-content" style="display:none;">
        <h2><?php esc_html_e('Customization', 'eduna-online-course'); ?></h2>
        <table class="widefat">
            <thead>
                <tr>
                    <th><?php esc_html_e('Step', 'eduna-online-course'); ?></th>
                    <th><?php esc_html_e('Action', 'eduna-online-course'); ?></th>
                </tr>
            </thead>
            <tbody>
                
                <tr>
                    <td><b><?php esc_html_e('Customization:', 'eduna-online-course'); ?></b></td>
                    <td>
                    <?php esc_html_e('We use the popular Tutor LMS plugin for managing courses. If you are selling products, you can integrate both WooCommerce and Tutor LMS. Alternatively, you can use Tutor LMS’s built-in cart, checkout, and payment system.', 'eduna-online-course'); ?><br>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=tutor_settings')); ?>" target="_blank" class="button button-secondary  btn-demo">
                            <?php esc_html_e('Check Tutor Settings', 'eduna-online-course'); ?>
                        </a>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div id="features" class="tab-content" style="display:none;">
        <h2><?php esc_html_e('Free vs Pro Features', 'eduna-online-course'); ?></h2>
        <table class="widefat">
            <thead>
                <tr>
                    <th><?php esc_html_e('Feature', 'eduna-online-course'); ?></th>
                    <th><?php esc_html_e('Free', 'eduna-online-course'); ?></th>
                    <th><?php esc_html_e('Pro', 'eduna-online-course'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php esc_html_e('One-Click Demo Import', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Customize', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Limited', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Advanced', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Header & Footer Customize', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Default', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Drag & Drop Customize', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('LMS Page Design', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Limited', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Complete', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Woocommerce Ready', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Yes', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Yes', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Section', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 10 Section', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 50+ Sections', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Blog', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 1 Style', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 3+ Styles', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Blog Widget', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Limited', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Advanced', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Blog Single', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 1 Layout', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ 3 Layout', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Breadcrumb', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Fixed', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Customizable', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Course Page', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Limited', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Complete', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Animations', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Scroll Up', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Preloader', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Video Popup', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('FunFact', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Teachers Page', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Testimonial', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Brands', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Call to Action', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Contact Form', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Default', 'eduna-online-course'); ?></td>
                    <td><?php esc_html_e('✅ Advanced', 'eduna-online-course'); ?></td>
                </tr>
                <tr>
                    <td><?php esc_html_e('Premium Support', 'eduna-online-course'); ?></td>
                    <td>❌</td>
                    <td>✅</td>
                </tr>
            </tbody>

        </table>
    </div>

    <div id="documentation" class="tab-content" style="display:none;">
        <h2><?php esc_html_e('Documentation & Support', 'eduna-online-course'); ?></h2>
        <p><a href="https://pencilwp.com/docs/eduna-online-course/" class="button button-primary" target="_blank"><?php esc_html_e('View Full Documentation', 'eduna-online-course'); ?></a></p>
    </div>
</div>
