<?php 

// Add Admin Menu
function eduna_online_course_add_admin_menu() {
    add_menu_page(
        'Eduna Online Course Settings', // Page Title
        'Eduna Online Course', // Menu Title
        'manage_options', // Capability
        'eduna-online-course-settings', // Menu Slug
        'eduna_online_course_admin_page', // Callback Function
        'dashicons-welcome-learn-more', // Icon
        2 // Position (top)
    );
}
add_action('admin_menu', 'eduna_online_course_add_admin_menu');

// Include the Admin Page
function eduna_online_course_admin_page() {
    include_once get_template_directory() . '/includes/admin/admin-settings.php';
}


function eduna_online_course_dashboard_notice() {
    // Show notice on Dashboard or Themes page
    $current_screen = get_current_screen();
    if ( ! in_array( $current_screen->base, ['dashboard', 'themes'] ) ) {
        return;
    }
    ?>
    <div class="eduna-dashboard-notice notice notice-info is-dismissible">
        <p class="eduna-notice-title">
            <strong><?php printf( esc_html__( 'Hello, %s 👋🏻 You are using the free version of Eduna Online Course.', 'eduna-online-course' ), esc_html( get_bloginfo( 'name' ) ) ); ?></strong>
        </p>
        
        <p class="eduna-notice-upgrade">
            <strong><?php esc_html_e( 'Eduna Online Course Pro 🚀 – Make your Online Education & Course Website to the Next Level!', 'eduna-online-course' ); ?></strong>
        </p>
        
        <p class="eduna-notice-text">
            <?php esc_html_e( 'Build your education or LMS website effortlessly with woocommerce ready, premade demos, advanced customization, and SEO-optimized features.', 'eduna-online-course' ); ?>
        </p>
        
        <p class="eduna-notice-buttons">
            <a href="<?php echo esc_url(admin_url('admin.php?page=eduna-online-course-settings')); ?>" class="button button-primary">
                <?php esc_html_e( 'Install Free Version', 'eduna-online-course' ); ?>
            </a>     
            <a href="<?php echo esc_url( 'https://pencilwp.com/product/eduna-lms-pro' ); ?>" class="button button-primary eduna-btn-pro" target="_blank">
                <?php esc_html_e( 'Upgrade to Premium', 'eduna-online-course' ); ?>
            </a>
        </p>
    </div>
    <?php
}
add_action( 'admin_notices', 'eduna_online_course_dashboard_notice' );


// Enqueue Styles & Scripts
function eduna_online_course_admin_assets($hook) {
    // Load styles for Dashboard (index.php), Settings page, and Themes page
    if ($hook !== 'toplevel_page_eduna-online-course-settings' && $hook !== 'index.php' && $hook !== 'themes.php') return;

    wp_enqueue_style('eduna-online-course-admin-style', get_template_directory_uri() . '/includes/admin/assets/admin-style.css');
    wp_enqueue_script('eduna-online-course-admin-script', get_template_directory_uri() . '/includes/admin/assets/admin-scripts.js', array('jquery'), false, true);
}
add_action('admin_enqueue_scripts', 'eduna_online_course_admin_assets');
