<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Eduna Online Course
 */

?>
</div><!-- #content -->
	<footer id="colophon" class="eduna-online-course-footer">
		<?php if(is_active_sidebar('eduna-online-course-footer-1')) : ?>
		<div class="eduna-online-course-footer__top">
			<div class="container">
				<div class="row">
					<?php if(is_active_sidebar('eduna-online-course-footer-1')) : ?>
						<div class="col-lg-4 col-md-3 col-12 eduna-online-course-footer-1">
							<?php dynamic_sidebar('eduna-online-course-footer-1'); ?>
						</div>
					<?php endif; ?>
					<div class="col-lg-8 col-md-9 col-12">
						<div class="row">
							<?php if(is_active_sidebar('eduna-online-course-footer-2')) : ?>
								<div class="col-lg-4 col-md-4 col-12">
									<?php dynamic_sidebar('eduna-online-course-footer-2'); ?>
								</div>
							<?php endif; ?>
							<?php if(is_active_sidebar('eduna-online-course-footer-3')) : ?>
								<div class="col-lg-4 col-md-4 col-12">
									<?php dynamic_sidebar('eduna-online-course-footer-3'); ?>
								</div>
							<?php endif; ?>
							<?php if(is_active_sidebar('eduna-online-course-footer-4')) : ?>
								<div class="col-lg-4 col-md-4 col-12">
									<?php dynamic_sidebar('eduna-online-course-footer-4'); ?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>

		<div class="eduna-online-course-footer__bottom">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="eduna-online-course-footer__branding text-center">
							<p class="eduna-online-course-footer__site"><?php esc_html_e('&copy; All Right Reserved ','eduna-online-course'); ?> <a class="eduna-online-course-footer__url" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo('title'); ?></a> <?php echo  esc_html(date_i18n( __( 'Y' , 'eduna-online-course' ) ));?></p>
							<p class="eduna-online-course-footer__devs"><?php
							printf( esc_html__( 'Theme Provided By  %1$s', 'eduna-online-course' ), '<a href="https://pencilwp.com/" target="_blank" >PencilWp</a>' );?></p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>
	
</div><!-- End Page -->

<?php wp_footer(); ?>

</body>
</html>
