<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Eduna Online Course
 */

get_header();
?>


	 <!-- Start Error Area  -->
	 <section class="ed-error ed-section-padding">
		<div class="container ed-container">
			<div class="row justify-content-center">
				<div class="col-lg-6 col-md-8 col-12">
					<div class="ed-error__inner text-center">
						<div class="ed-error__content">
							<h1 class="eduna-online-course-404__title">
								<?php esc_html_e( '404 Error', 'eduna-online-course' ); ?> <span></span>
							</h1>
							<p class="ed-error__content-text">
								<?php esc_html_e( 'Seems like you\'ve landed on a page which has been archived or removed, let\'s take you back home?', 'eduna-online-course' ); ?>
							</p>
							<div class="ed-error__btn">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="ed-btn-custom"><?php esc_html_e( 'Go to Homepage', 'eduna-online-course' ); ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End Error Area  -->

<?php
get_footer();