<?php
/**
 * Business agency default theme options.
 *
 *
 * @subpackage Business agency
 */

if ( !function_exists('education_method_get_default_theme_options' ) ) :

    /**
     * Get default theme options.
     *
     * @since 1.0.0
     *
     * @return array Default theme options.
     */
    function education_method_get_default_theme_options()
    {

        $default = array();

        // Homepage Slider Section
        $default['education_method_homepage_slider_option'] = 'hide';
        $default['education_method_slider_cat_id'] = 0;
        $default['education_method_no_of_slider'] = 3;
        $default['education_method_slider_get_started_txt'] = esc_html__('Get Started!', 'education-ready');
        $default['education_method_slider_get_started_link'] = '#';

        // footer copyright.
        $default['education_method_copyright'] = esc_html__('Copyright Text', 'education-ready');

        // Home Page Top header Info.
        $default['education_method_top_header_section'] = 'hide';
        $default['education_method_notice_title']= esc_html__('Notice', 'education-ready');
        $default['education_method_news_cat_id']='';
        $default['education_method_no_of_news']=5;
        $default['education_method_social_link_hide_option'] = 1;

        $default['education_method_button']=esc_html__('Contact Us', 'education-ready');
        $default['education_method_apply_button_link']='';

        // Blog.
        $default['education_method_sidebar_layout_option'] = 'right-sidebar';
        $default['education_method_blog_title_option'] = esc_html__('Latest Blog', 'education-ready');
        $default['education_method_blog_excerpt_option'] = 'excerpt';
        $default['education_method_description_length_option'] = 40;
        $default['education_method_exclude_cat_blog_archive_option'] = '';


        // Details page.
        $default['education_method_show_feature_image_single_option'] = 'show';

        // Color Option.
        $default['education_method_primary_color'] = '#ff410d; ';

        $default['education_method_top_header_background_color'] = '#ff410d; ';
        $default['education_method_top_footer_background_color'] = '#444444';
        $default['education_method_bottom_footer_background_color'] = '#444444';
        $default['education_method_front_page_hide_option'] = 0;
        $default['education_method_breadcrumb_setting_option'] = 'enable';
        $default['education_method_post_search_placeholder_option'] = esc_html__('Search', 'education-ready');
        $default['education_method_hide_breadcrumb_front_page_option'] = 0;
        $default['education_method_color_reset_option'] = 'do-not-reset';

        //company info
        $default['education_method_info_header_section']='hide';
        $default['education_method_info_header_section_location_icon']='fa-home';
        $default['education_method_info_header_location']='';
        $default['education_method_info_header_section_phone_number_icon']='fa-phone';
        $default['education_method_info_header_phone_no']='';
        $default['education_method_email_icon']='fa-envelope-o';
        $default['education_method_info_header_email']='';

        $default['education_method_about_us_background_color']='#fff';
        $default['education_method_about_us1_background_color']='#fff';



        // Pass through filter.
        $default = apply_filters( 'education_method_get_default_theme_options', $default );
        return $default;
    }
endif;
