<?php
function educa_get_theme_var() {
	
	$slide_one_id	= get_theme_mod('educa_slider_one', 0);
	$slide_two_id	= get_theme_mod('educa_slider_two', 0);
	$slide_three_id	= get_theme_mod('educa_slider_three', 0);

	if($slide_one_id){
		$slide_one_image = wp_get_attachment_image_src(get_post_thumbnail_id($slide_one_id), 'full');
		$slide_one_image = $slide_one_image[0];
	}else{
		$slide_one_image = get_template_directory_uri() . '/images/notebook-336634_1920.jpg';
	}
	if($slide_two_id){
		$slide_two_image = wp_get_attachment_image_src(get_post_thumbnail_id($slide_two_id), 'full');
		$slide_two_image = $slide_two_image[0];
	}else{
		$slide_two_image = get_template_directory_uri() . '/images/girl-995187_1920.jpg';
	}
	if($slide_three_id){
		$slide_three_image = wp_get_attachment_image_src(get_post_thumbnail_id($slide_three_id), 'full');
		$slide_three_image = $slide_three_image[0];
	}else{
		$slide_three_image = get_template_directory_uri() . '/images/library-898333_1920.jpg';
	}
	

	$educa_theme_data = array(

		'social_link_open_in_new_tab' => get_theme_mod('educa_social_link_open_in_new_tab', true),
		'social_link_facebook'        => get_theme_mod('educa_social_link_facebook', '#'),
		'social_link_google'          => get_theme_mod('educa_social_link_google', '#'),
		'social_link_youtube'         => get_theme_mod('educa_social_link_youtube', '#'),
		'social_link_twitter'         => get_theme_mod('educa_social_link_twitter', '#'),
		'social_link_linkedin'        => get_theme_mod('educa_social_link_linkedin', '#'),

		'hide_home_slider'            => get_theme_mod('educa_hide_home_slider', false),
		'slide_1' 					  => ($slide_one_id)?get_post($slide_one_id):(object)array('post_title' => __('Awesome Education Theme', 'educa'), 'post_content' => __('Education is the most powerful weapon', 'educa')),
		'slide_2' 					  => ($slide_two_id)?get_post($slide_two_id):(object)array('post_title' => __('Awesome Education Theme', 'educa'), 'post_content' => __('Education is the most powerful weapon', 'educa')),
		'slide_3' 					  => ($slide_three_id)?get_post($slide_three_id):(object)array('post_title' => __('Awesome Education Theme', 'educa'), 'post_content' => __('Education is the most powerful weapon', 'educa')),

		'slider_image_one'            => $slide_one_image,
		'slider_image_two'            => $slide_two_image,
		'slider_image_three'          => $slide_three_image,
		'slide_button_text'           => get_theme_mod('educa_slide_button_text', __('Click To Begin', 'educa')),
		'slide_button_link'           => get_theme_mod('educa_slide_button_link', '#'),

		'services_header_text'        => get_theme_mod('educa_services_header_text', __('Awesome Services', 'educa')),
		'services_desc_text'          => get_theme_mod('educa_services_desc_text', __('Free Education For Every one', 'educa')),
		'services_1_title'            => get_theme_mod('educa_services_1_title', __('Responsive Design', 'educa')),
		'services_1_desc'             => get_theme_mod('educa_services_1_desc', __('Free Education For Every one', 'educa')),
		'services_2_title'            => get_theme_mod('educa_services_2_title', __('Google Fonts', 'educa')),
		'services_2_desc'             => get_theme_mod('educa_services_2_desc', __('Free Education For Every one', 'educa')),
		'services_3_title'            => get_theme_mod('educa_services_3_title', __('Translation Ready', 'educa')),
		'services_3_desc'             => get_theme_mod('educa_services_3_desc', __('Free Education For Every one', 'educa')),
		'services_4_title'            => get_theme_mod('educa_services_4_title', __('1200+ Video Lessons', 'educa')),
		'services_4_desc'             => get_theme_mod('educa_services_4_desc', __('Free Education For Every one', 'educa')),

		'home_latest_news_title'      => get_theme_mod('educa_home_latest_news_title', __('Our Blog', 'educa')),
		'home_latest_news_desc'       => get_theme_mod('educa_home_latest_news_desc', __('Be updated with latest posts from educa', 'educa')),

		'home_cta_title'              => get_theme_mod('educa_home_cta_title', __('Callout Heading', 'educa')),
		'home_cta_desc'               => get_theme_mod('educa_home_cta_desc', __('Callout Description','educa')),
		'home_cta_image'		  	  => get_theme_mod('educa_home_cta_image', get_template_directory_uri() . '/images/scrabble-921254_1920.jpg'),
		'home_cta_one_url'            => get_theme_mod('educa_home_cta_one_url', '#'),
		'home_cta_one_text'			  => get_theme_mod('educa_home_cta_one_text', __('Register Now','educa')),
		'home_cta_two_url'            => get_theme_mod('educa_home_cta_two_url', '#'),
		'home_cta_two_text'			  => get_theme_mod('educa_home_cta_two_text', __('View Course','educa')),
		
		
	);
	return $educa_theme_data;

}

?>