<?php

function educa_upgrade_control($wp_customize) {

	class Educa_Page_Dropdown_Control extends WP_Customize_Control {

		public function render_content() {
			$pages = get_pages(array('hide_empty' => false));
			if (!empty($pages)): ?>
					<label>
						<span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
						<select <?php $this->link();?>>
							<option value="0"><?php esc_html_e('Select Page', 'educa');?></option>
						<?php
							foreach ($pages as $page):
								printf('<option value="%s" %s>%s</option>',
									$page->ID,
									selected($this->value(), $page->ID, false),
									$page->post_title
								);
							endforeach;
							?>
						</select>
					</label>
				<?php
			endif;
		}

	}

	class Educa_Pro_Customize_Control extends WP_Customize_Control {

		public function render_content() {
			?>
			<div class="theme-farmer-pro">

				<div class="pro-version">
					<div class="">
						<img src="<?php echo get_template_directory_uri() . '/screenshot.png'; ?>" />
					</div>
					<?php _e('The Pro Version gives you more opportunities to enhance your site and business. In order to create effective online presence one have to showcase their wide range of products, have to use contact us inquiry form, have to make effective about us page, have to introduce team members, etc etc . The pro version will give it all. Buy the pro version and give us a chance to serve you better. ', 'educa');?>
				</div>
				<a href="<?php echo esc_url('https://www.themefarmer.com/product/educa-pro/'); ?>" target="_blank" class="cdns-upgrade" id="cdns-upgrade-pro"><?php _e('UPGRADE  TO PRO ', 'educa');?></a>
			</div>
			<?php
		}

	}

	class Educa_Info_Customize_Control extends WP_Customize_Control {

		public function render_content() {
			?>
			<div class="info-notes">
					<?php echo esc_html($this->label); ?> 
			</div>
			<?php
		}

	}

	$wp_customize->add_section('educa_upgarde_pro_section', array(
		'title'    => __('UPGRADE  TO PRO VERSION', 'educa'),
		'priority' => 1000,
	));

	$wp_customize->add_setting('upgrade_to_pro', array(
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'educa_sanitize_html',
	));
	$wp_customize->add_control(new Educa_Pro_Customize_Control($wp_customize, 'upgrade_to_pro', array(
		'label'   => __('Discover Educa Pro', 'educa'),
		'section' => 'educa_upgarde_pro_section',
		'setting' => 'upgrade_to_pro',
	)));

}

function educa_devider_control($wp_customize) {
	class Educa_Pro_Devider extends WP_Customize_Control {

		public function render_content() {
			?>
			<div class="theme-farmer-separator">
				<?php echo esc_html($this->label); ?>
			</div>
			<?php
		}

	}

	function print_devider($wp_customize, $section, $id, $title) {

		$wp_customize->add_setting('educa_devider' . $id, array(
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'educa_sanitize_html',
		));
		$wp_customize->add_control(new Educa_Pro_Devider($wp_customize, 'educa_devider' . $id, array(
			'label'    => $title,
			'section'  => $section,
			'priority' => 1,
			'setting'  => 'educa_devider' . $id,
		)));
	}

	$wp_customize->add_panel('educa_homepage_options', array(
		'priority'    => 1,
		'capability'  => 'edit_theme_options',
		'title'       => __('Home Page Options', 'educa'),
		'description' => __('Here you can customize theme data', 'educa'),
	));

	/** Slider **/

	$wp_customize->add_section('educa_slider_section', array(
		'title'      => __('Slider Settings', 'educa'),
		'priority'   => 1,
		'capability' => 'edit_theme_options',
		'panel'      => 'educa_homepage_options',
	));

	$wp_customize->add_setting('educa_hide_home_slider',
		array(
			'default'           => false,
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_checkbox',
		)
	);

	$wp_customize->add_control('educa_hide_home_slider', array(
		'type'     => 'checkbox',
		'priority' => 1,
		'section'  => 'educa_slider_section',
		'label'    => __('Hide Home Slider ', 'educa'),
	));

	
	$wp_customize->add_setting('educa_slider_note', array(
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'educa_sanitize_html',
	));
	$wp_customize->add_control(new Educa_Info_Customize_Control($wp_customize, 'educa_slider_note', array(
		'label'    => __('INFO: WordPress Page work as slide select any page to show in slider. Featured image work as slide image, title as slider caption title, and content as caption description', 'educa'),
		'priority' => 100,
		'section' => 'educa_slider_section',
		'setting' => 'educa_slider_note',
	)));

	print_devider($wp_customize, 'educa_slider_section', '1', __('Slider One Settings', 'educa'));

	$wp_customize->add_setting('educa_slider_one', array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'absint',

	));
	$wp_customize->add_control(new Educa_Page_Dropdown_Control($wp_customize, 'educa_slider_one',
		array(
			'label'    => __('Slide One Page', 'educa'),
			'section'  => 'educa_slider_section',
			'priority' => 1,
		)));

	print_devider($wp_customize, 'educa_slider_section', '2', __('Slider Two Settings', 'educa'));

	$wp_customize->add_setting('educa_slider_two', array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'absint',

	));
	$wp_customize->add_control(new Educa_Page_Dropdown_Control($wp_customize, 'educa_slider_two',
		array(
			'label'    => __('Slide Two Page', 'educa'),
			'section'  => 'educa_slider_section',
			'priority' => 1,
		)));

	print_devider($wp_customize, 'educa_slider_section', '4', __('Slider Three Settings', 'educa'));

	$wp_customize->add_setting('educa_slider_three', array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'absint',

	));
	$wp_customize->add_control(new Educa_Page_Dropdown_Control($wp_customize, 'educa_slider_three',
		array(
			'label'    => __('Slide Three Page', 'educa'),
			'section'  => 'educa_slider_section',
			'priority' => 1,
		)));

	print_devider($wp_customize, 'educa_slider_section', '2_a', __('Slider Button', 'educa'));

	$wp_customize->add_setting('educa_slide_button_text',
		array(
			'default'           => __('Click To Begin', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_nohtml',
		));

	$wp_customize->add_control('educa_slide_button_text', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_slider_section',
		'label'    => __('Button Text', 'educa'),
	));

	$wp_customize->add_setting('educa_slide_button_link',
		array(
			'default'           => '#',
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		));

	$wp_customize->add_control('educa_slide_button_link', array(
		'type'     => 'url',
		'priority' => 1,
		'section'  => 'educa_slider_section',
		'label'    => __('Button Link', 'educa'),
	));

	/** Slider **/

	/** services **/

	$wp_customize->add_section('educa_servces_section', array(
		'title'      => __('Services Settings', 'educa'),
		'priority'   => 1,
		'capability' => 'edit_theme_options',
		'panel'      => 'educa_homepage_options',
	));

	$wp_customize->add_setting('educa_services_header_text',
		array(
			'default'           => __('Awesome Services', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control('educa_services_header_text', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Title Text', 'educa'),
	));

	$wp_customize->add_setting('educa_services_desc_text',
		array(
			'default'           => __('We are a group of passionate designers and developers who really love to create awesome WordPress themes & support', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_services_desc_text', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Description Text', 'educa'),
	));

	print_devider($wp_customize, 'educa_servces_section', '5', __('Services One', 'educa'));

	$wp_customize->add_setting('educa_services_1_title',
		array(
			'default'           => __('Responsive Design', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control('educa_services_1_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Title', 'educa'),
	));

	$wp_customize->add_setting('educa_services_1_desc',
		array(
			'default'           => __('Free Education For Every one', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_services_1_desc', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Description', 'educa'),
	));

	print_devider($wp_customize, 'educa_servces_section', '6', __('Services Two', 'educa'));

	$wp_customize->add_setting('educa_services_2_title',
		array(
			'default'           => __('Google Fonts', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control('educa_services_2_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Title', 'educa'),
	));

	$wp_customize->add_setting('educa_services_2_desc',
		array(
			'default'           => __('Free Education For Every one', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_services_2_desc', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Description', 'educa'),
	));

	print_devider($wp_customize, 'educa_servces_section', '7', __('Services Three', 'educa'));

	$wp_customize->add_setting('educa_services_3_title',
		array(
			'default'           => __('Translation Ready', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control('educa_services_3_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Title', 'educa'),
	));

	$wp_customize->add_setting('educa_services_3_desc',
		array(
			'default'           => __('Free Education For Every one', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_services_3_desc', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Description', 'educa'),
	));

	print_devider($wp_customize, 'educa_servces_section', '8', __('Services Four', 'educa'));

	$wp_customize->add_setting('educa_services_4_title',
		array(
			'default'           => __('1200+ Video Lessons', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control('educa_services_4_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Title', 'educa'),
	));

	$wp_customize->add_setting('educa_services_4_desc',
		array(
			'default'           => __('Free Education For Every one', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_services_4_desc', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_servces_section',
		'label'    => __('Description', 'educa'),
	));

	/** services **/

	/* CTA */
	$wp_customize->add_section( 'educa_home_cta_section', array(
		'title'         =>    __( 'Callout Settings', 'educa' ), 
		'priority'      =>    1, 
		'capability'    =>    'edit_theme_options', 
		'panel'         =>    'educa_homepage_options',
		));

	$wp_customize->add_setting( 'educa_home_cta_title', 
		array(
			'default' =>__('Callout Heading', 'educa'),
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'sanitize_text_field',
			));

	$wp_customize->add_control( 'educa_home_cta_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Heading', 'educa'),
		));

	$wp_customize->add_setting( 'educa_home_cta_desc', 
		array(
			'default' => __('Callout Description','educa'),
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'sanitize_text_field',
			));

	$wp_customize->add_control( 'educa_home_cta_desc', array(
		'type'     => 'textarea',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Description', 'educa'),
		));
	$wp_customize->add_setting( 'educa_home_cta_image', 
		array(
			'default' => get_template_directory_uri() . '/images/scrabble-921254_1920.jpg',
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'educa_sanitize_url',
			'type' => 'theme_mod',
			));
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'educa_home_cta_image', array(
	  'label' => __( 'Background Image', 'educa' ),
	  'priority' => 1,
	  'section'  => 'educa_home_cta_section',
	) ) );

	$wp_customize->add_setting( 'educa_home_cta_one_text', 
		array(
			'default' => __('Register Now','educa'),
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'sanitize_text_field',
			));

	$wp_customize->add_control( 'educa_home_cta_one_text', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Button One Text', 'educa'),
		));

	$wp_customize->add_setting( 'educa_home_cta_one_url', 
		array(
			'default' =>'#',
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'educa_sanitize_url',
			));

	$wp_customize->add_control( 'educa_home_cta_one_url', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Button One URL', 'educa'),
		));


	$wp_customize->add_setting( 'educa_home_cta_two_text', 
		array(
			'default' => __('View Course','educa'),
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'sanitize_text_field',
			));

	$wp_customize->add_control( 'educa_home_cta_two_text', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Button Two Text', 'educa'),
		));

	$wp_customize->add_setting( 'educa_home_cta_two_url', 
		array(
			'default' => '#',
			'type' => 'theme_mod', 
			'capability' => 'edit_theme_options', 
			'transport' => 'refresh', 
			'sanitize_callback' => 'educa_sanitize_url',
			));

	$wp_customize->add_control( 'educa_home_cta_two_url', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_cta_section',
		'label'    => __('Button Two URL', 'educa'),
		));
	/* CTA */

	/* Latest Posts*/

	$wp_customize->add_section('educa_home_latest_news_section', array(
		'title'      => __('Latest Blog Settings', 'educa'),
		'priority'   => 1,
		'capability' => 'edit_theme_options',
		'panel'      => 'educa_homepage_options',
	));

	$wp_customize->add_setting('educa_home_latest_news_title',
		array(
			'default'           => __('Our Blog', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_home_latest_news_title', array(
		'type'     => 'text',
		'priority' => 1,
		'section'  => 'educa_home_latest_news_section',
		'label'    => __('Heading', 'educa'),
	));

	$wp_customize->add_setting('educa_home_latest_news_desc',
		array(
			'default'           => __('Be updated with latest posts from educa', 'educa'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		));

	$wp_customize->add_control('educa_home_latest_news_desc', array(
		'type'     => 'textarea',
		'priority' => 1,
		'section'  => 'educa_home_latest_news_section',
		'label'    => __('Description', 'educa'),
	));

	/* Latest Posts*/	

	/** Top Bar **/
	$wp_customize->add_section('educa_top_bar_section', array(
		'title'      => __('Social Settings', 'educa'),
		'priority'   => 1,
		'capability' => 'edit_theme_options',
		
	));

	$wp_customize->add_setting('educa_social_link_open_in_new_tab',
		array(
			'default'           => true,
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_checkbox',
		));

	$wp_customize->add_control('educa_social_link_open_in_new_tab', array(
		'type'     => 'checkbox',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Open social links in new tab', 'educa'),
	));

	$wp_customize->add_setting('educa_social_link_facebook',
		array(
			'default'           => esc_url('#'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		)
	);

	$wp_customize->add_control('educa_social_link_facebook', array(
		'type'     => 'url',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Facebook Page URL', 'educa'),
	));

	$wp_customize->add_setting('educa_social_link_google',
		array(
			'default'           => esc_url('#'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		)
	);

	$wp_customize->add_control('educa_social_link_google', array(
		'type'     => 'url',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Google Page URL', 'educa'),
	));

	$wp_customize->add_setting('educa_social_link_youtube',
		array(
			'default'           => esc_url('#'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		)
	);

	$wp_customize->add_control('educa_social_link_youtube', array(
		'type'     => 'url',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Youtube Page URL', 'educa'),
	));

	$wp_customize->add_setting('educa_social_link_twitter',
		array(
			'default'           => esc_url('#'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		)
	);
	$wp_customize->add_control('educa_social_link_twitter', array(
		'type'     => 'url',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Twitter Page URL', 'educa'),
	));

	$wp_customize->add_setting('educa_social_link_linkedin',
		array(
			'default'           => esc_url('#'),
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
			'sanitize_callback' => 'educa_sanitize_url',
		)
	);
	$wp_customize->add_control('educa_social_link_linkedin', array(
		'type'     => 'url',
		'priority' => 200,
		'section'  => 'educa_top_bar_section',
		'label'    => __('Linkedin Page URL', 'educa'),
	));

	/** Top Bar **/

	$wp_customize->get_section('title_tagline')->priority     = 10;
	$wp_customize->get_section('static_front_page')->priority = 30;
	$wp_customize->get_section('header_image')->priority = 50;
	

}

add_action('customize_register', 'educa_upgrade_control');
add_action('customize_register', 'educa_devider_control');

?>
