<?php
/**
 * Sample implementation of the Custom Header feature.
 *
 * You can add an optional custom header image to header.php like so ...
 *
	<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
		<img src="<?php header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="">
	</a>
	<?php endif; // End header image check. ?>
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package _s
 */

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses educa_header_style()
 */
function educa_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'educa_custom_header_args', array(
		'default-image' => get_template_directory_uri() . '/images/notebook-336634_1920.jpg',
		'flex-height'            => true,
		'header-text'            => false,
		'width'                  => 1200,
    	'height'                 => 700,
		'wp-head-callback'       => 'educa_header_style',
	) ) );
	
}
add_action( 'after_setup_theme', 'educa_custom_header_setup' );

if ( ! function_exists( 'educa_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 *
 * @see educa_custom_header_setup().
 */
function educa_header_style() {
	
	// If we get this far, we have custom styles. Let's do this.
	?>
	<?php if ( get_header_image() ) : ?>
	<style type="text/css">
	.edu_breadcum_pics {
    	background-image: url(<?php header_image(); ?>);
	}
	</style>
	<?php endif; // End header image check. 
	
}
endif;
