<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Educa
 */

get_header(); ?>
<!-- Breadcum Start -->
<?php 	educa_get_title_breadcrumb_tile(); 	?>
<!-- Breadcum End -->
<div class="clearfix"></div>
<section class="container-fluid edu_space edu_blogs">
	<div class="container">
		<div class="row edu_blog">
			<div class="col-md-9 edu_rightside edu_gallery">
				<section class="error-404 not-found">
					<div class="col-md-12 page-header error">
							<h1>40<span class="grey">4</span></h1>
							<h2><span class="fa fa-exclamation-circle"></span> <?php _e('ERROR', 'educa'); ?></h2>
							<h3><?php _e('Page cannot be found', 'educa'); ?></h3>
							<p><?php _e('The Page you requested is not be found. This could be spelling error in the url.', 'educa'); ?></p>
							<a href="/" class="btn"><?php _e('Go back to homepage', 'educa'); ?></a>
					</div><!-- .page-header -->
	
					<div class="page-content">
						<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'educa' ); ?></p>
						<?php
							get_search_form();
	
							the_widget( 'WP_Widget_Recent_Posts' );
	
							// Only show the widget if site has multiple categories.
							if ( educa_categorized_blog() ) :
						?>
						<div class="widget widget_categories">
							<h2 class="widget-title"><?php esc_html_e( 'Most Used Categories', 'educa' ); ?></h2>
							<ul>
							<?php
								wp_list_categories( array(
									'orderby'    => 'count',
									'order'      => 'DESC',
									'show_count' => 1,
									'title_li'   => '',
									'number'     => 10,
								) );
							?>
							</ul>
						</div><!-- .widget -->
	
						<?php
							endif;
	
							/* translators: %1$s: smiley */
							$archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'educa' ), convert_smilies( ':)' ) ) . '</p>';
							the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$archive_content" );
	
							the_widget( 'WP_Widget_Tag_Cloud' );
						?>
	
					</div><!-- .page-content -->
				</section><!-- .error-404 -->
			</div>
			<!-- Sidebar Start -->
			<div class="col-md-3 edu_left_sidebar">
				<?php get_sidebar(); ?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
