<?php
/**
* @Theme Name	:	Educa
* @file         :	home-blog.php
* @package      :	educa
* @author       :	Theme Farmer
* @license      :	readme.txt
* @filesource   :	wp-content/themes/educa/templates/home-blog.php
*/

$theme_data = educa_get_theme_var();
?>
<!-- Blog Start -->
<section class="container-fluid edu_space edu_blogs">
	<div class="row section_title_heading">
		<h1 class="section_title"> <?php echo esc_html($theme_data['home_latest_news_title']); ?> </h1>
		<p class="section_description"> <?php echo esc_html($theme_data['home_latest_news_desc']); ?> </p>
	</div>
	<div class="container">
		<div class="row edu_blog edu_gallery">
			<?php
				$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				$args = array( 'post_type' => 'post', 'paged'=>$paged, 'posts_per_page' => 3, 'ignore_sticky_posts' => 1, );
				$post_type_data = new WP_Query( $args );
				while($post_type_data->have_posts()){
					$post_type_data->the_post();
					get_template_part('template-parts/content','home'); 
				}
			?>
		</div>
	</div>
</section>
<!-- Blog End -->