<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Educa
 */

?>
<div id="post-<?php the_ID(); ?>" <?php post_class('row edu_blog_post'); ?>>
	<div class="col-md-12 edu_post">
		<?php 
		$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), '825x350-crop' );
		$image1 = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
		?>
		<?php if($image): ?>
			<div class="img-thumbnail">
				<?php the_post_thumbnail(); ?>
				<div class="overlay">
					<a class="edu-left lightbox_a" href="<?php echo $image1[0]; ?>"><span class="fa fa-search"></span></a>
					<a class="edu-right" href="<?php echo esc_url( get_permalink() ); ?>"><span class="fa fa-chain"></span></a>
				</div>
			</div>
			<?php endif; ?>	
			<?php	
				if ( 'post' === get_post_type() ) : ?>
				<?php educa_print_entry_meta(); ?>
				<?php
				endif; 
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			?>
			<?php
				the_excerpt();
			
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'educa' ),
					'after'  => '</div>',
				) );
			?>
			<a href="<?php echo esc_url( get_permalink() ); ?>" class="btn"><?php _e('Read More','educa'); ?></a>
	</div>
</div>