<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Educa
 */

?>
<div id="post-<?php the_ID(); ?>" <?php post_class('row edu_blog_post'); ?>>
	<div class="col-md-12 edu_post">
		<?php 
		$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), '825x350-crop' );
		$image1 = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
		?>
		<?php if($image): ?>
			<div class="img-thumbnail">
				<img src="<?php echo $image[0]; ?>" class="img-responsive" alt=" <?php the_title(); ?>"/>
				<div class="overlay">
					<a class="edu-left lightbox_a" href="<?php echo $image1[0]; ?>"><span class="fa fa-search"></span></a>
					<a class="edu-right" href="<?php echo esc_url( get_permalink() ); ?>"><span class="fa fa-chain"></span></a>
				</div>
			</div>
			<?php endif; ?>	
			<?php	
				the_title( '<h1 class="entry-title">', '</h1>' );				
			?>
			<?php
				the_content();
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'educa' ),
					'after'  => '</div>',
				) );
			?>
	</div>
</div>
<div class="clearfix"></div>