<?php
/**
 * The sidebar containing the main widget area.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Educa
 */

if (is_active_sidebar( 'sidebar-widget-area' ) ) {
	?>
	<!-- Sidebar Start -->
	<div id="secondary" class="edu_left_sidebar_inner" role="complementary">
		<?php dynamic_sidebar( 'sidebar-widget-area' ); ?>
	</div><!-- #secondary -->
	<?php
}else{

	$args = array(
		'name'          => esc_html__( 'Sidebar', 'educa' ),
		'id'            => 'sidebar-widget-area',
		'description'   => __('Sidebar Widget Area', 'educa' ),
		'before_widget' => '<div id="%1$s" class="row sidebar-widget widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="edu-head"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	);
	the_widget('WP_Widget_Search', 'title='.__('Search','educa'), $args);
	the_widget('WP_Widget_Archives', null, $args);
	the_widget('WP_Widget_Recent_Posts', null, $args);
	the_widget('WP_Widget_Calendar', 'title='.__('Calendar','educa'), $args);
	the_widget('WP_Widget_Categories', null, $args);
	the_widget('WP_Widget_Tag_Cloud', null, $args);

}
?>
	
