<?php
function educa_get_social_block(){
    $theme_data = educa_get_theme_var();
    $open_new_tab = ($theme_data['social_link_open_in_new_tab'])?'target="_blank"':'';
    ?>
        <ul class="social edu_social">
        	<li class="facebook"><a href="<?php echo esc_url($theme_data['social_link_facebook']); ?>"  <?php echo esc_attr($open_new_tab); ?>><i class="fa fa-facebook icon"></i></a></li>
            <li class="google-plus"><a href="<?php echo esc_url($theme_data['social_link_google']); ?>"  <?php echo esc_attr($open_new_tab); ?>><i class="fa fa-google-plus icon"></i></a></li>
            <li class="twitter"><a href="<?php echo esc_url($theme_data['social_link_twitter']); ?>"  <?php echo esc_attr($open_new_tab); ?>><i class="fa fa-twitter icon"></i></a></li>
            <li class="pinterest"><a href="<?php echo esc_url($theme_data['social_link_youtube']); ?>"  <?php echo esc_attr($open_new_tab); ?>><i class="fa fa-youtube icon"></i></a></li>
            <li class="linkedin"><a href="<?php echo esc_url($theme_data['social_link_linkedin']); ?>"  <?php echo esc_attr($open_new_tab); ?>><i class="fa fa-linkedin icon"></i></a></li>
        </ul>    
    <?php
}

function educa_comment_form_fields($fields) {

    $fields['author'] = '<div class="form-group col-md-4"><label  for="name">' . __('NAME', 'educa') . ':</label><input type="text" class="form-control" id="name" name="author" placeholder="' . esc_attr__('Full Name', 'educa') . '"></div>';
    $fields['email']  = '<div class="form-group col-md-4"><label for="email">' . __('EMAIL', 'educa') . ':</label><input type="email" class="form-control" id="email" name="email" placeholder="' . esc_attr__('Your Email Address', 'educa') . '"></div>';
    $fields['url']    = '<div class="form-group col-md-4"><label  for="url">' . __('WEBSITE', 'educa') . ':</label><input type="text" class="form-control" id="url" name="url" placeholder="' . esc_attr__('Website', 'educa') . '"></div>';
    return $fields;

}
add_filter('comment_form_fields', 'educa_comment_form_fields');

function educa_comment_form_defaults($defaults) {
    $defaults['submit_field']   = '<div class="form-group col-md-4">%1$s %2$s</div>';
    $defaults['comment_field']  = '<div class="form-group col-md-12"><label  for="message">' . __('COMMENT', 'educa') . ':</label><textarea class="form-control" rows="5" id="comment" name="comment" placeholder="' . esc_attr__('Message', 'educa') . '"></textarea></div>';
    $defaults['title_reply_to'] = __('Post Your Reply Here To %s', 'educa');
    $defaults['class_submit']   = 'btn btn-theme';
    $defaults['label_submit']   = __('SUBMIT COMMENT', 'educa');
    $defaults['title_reply']    = '<h2>' . __('Post Your Comment Here', 'educa') . '</h2>';
    $defaults['role_form']      = 'form';
    return $defaults;

}
add_filter('comment_form_defaults', 'educa_comment_form_defaults');

function educa_comment( $comment, $args, $depth ){
    //get theme data
    global $comment_data;
    //translations
    $leave_reply = $comment_data['translation_reply_to_coment'] ? $comment_data['translation_reply_to_coment'] :__('Reply','educa'); ?>
    <div class="col-xs-12 comment-detail">
        <div class="col-xs-2 comments-pics">
        <?php echo get_avatar($comment, $size = '80'); ?>
        </div>
        <div class="col-xs-10 comments-text">
            <h3>
                <?php comment_author();?> 
                <span> 
                    <?php 
                        if ( ('d M  y') == get_option( 'date_format' ) ) : ?>
                    <?php comment_date('F j, Y');?>
                    <?php else : ?>
                    <?php comment_date(); ?>
                    <?php endif; ?>
                    <?php _e('at','educa');?>&nbsp;<?php comment_time('g:i a'); ?>
                 </span>
             </h3>  
             <p><?php comment_text() ; ?></p>
            <?php comment_reply_link(array_merge( $args, array('reply_text' => $leave_reply,'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            <?php if ( $comment->comment_approved == '0' ) : ?>
            <em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'educa' ); ?></em>
            <br/>
            <?php endif; ?>
        </div>
    </div>
    <?php
}
