<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Educa
 */

if ( ! function_exists( 'educa_print_entry_meta' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function educa_print_entry_meta() {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {
		
		
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		$tags_list = get_the_tag_list( '', ', ', '');
		$categories_list = get_the_category_list( ', ' );

		

		?>
		<ul class="post_date">
			<li class="p_date"><i class="fa fa-calendar"></i> <?php _e('On','educa'); ?> <a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo $time_string; ?></a></li>
			<li class="p_user"><i class="fa fa-user"></i> <?php _e('By','educa'); ?><span class="author vcard"><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"> <?php echo esc_html( get_the_author() ); ?></a> </span></li>
			<?php if (! post_password_required() && comments_open()) : ?>	
			<li class="p_comment"><i class="fa fa-comment"></i> <?php comments_popup_link( esc_html__( '0 Comment', 'educa' ), esc_html__( '1 Comment', 'educa' ), esc_html__( '% Comments', 'educa' ) ); ?></li>
			<?php endif; ?>
			<?php if ($categories_list): ?>
			<li class="p_cats blog-post-category cat-links"><i class="fa fa-thumb-tack"></i> <?php _e('Categories','educa'); ?>: <?php echo $categories_list; ?></li>
			<?php endif; ?>		
			<?php if ($tags_list): ?>
			<li class="p_tags blog-post-tags tag-links"><i class="fa fa-tags"></i> <?php _e('Tags','educa'); ?>: <?php echo $tags_list; ?></li>
			<?php endif; ?>			
		</ul>
		<?php
	}
	
}
endif;


/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function educa_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'educa_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'educa_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so educa_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so educa_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in educa_categorized_blog.
 */
function educa_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'educa_categories' );
}
add_action( 'edit_category', 'educa_category_transient_flusher' );
add_action( 'save_post',     'educa_category_transient_flusher' );
