<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Educa
 */

?>
			</div>
		</div>
	</div><!-- #content -->
	
	<!-- Footer Start -->
	<?php 
	    $footer_widget  = array(
    		'name' => __( 'Footer Widget Area', 'educa' ),
    		'id' => 'footer-widget-area',
    		'description' => __( 'footer widget area', 'educa' ),
    		'before_widget' => '<div class="col-md-3 col-sm-6 footer_widget clearfix">',
    		'after_widget'  =>  '</div>',
    		'before_title'  =>  '<div class="row widget_heading"><h1>',
    		'after_title'   =>  '</h1></div>', 
		);
	?>

	<footer>
		<div class="container-fluid edu_footer">
			<div class="container">
				<div class="row edu_footer_detail">
					<?php	if ( is_active_sidebar( 'footer-widget-area' ) ) { ?>
            			<?php dynamic_sidebar( 'footer-widget-area'); ?>
				    <?php }else{ 
				        the_widget('WP_Widget_Calendar', 'title='.__('Calendar','educa'), $footer_widget);
                		the_widget('WP_Widget_Categories', null, $footer_widget);
                		the_widget('WP_Widget_Pages', null, $footer_widget);
                		the_widget('WP_Widget_Archives', null, $footer_widget);
				    } ?>
				</div>
			</div>
		</div>
		<div class="container-fluid edu_footer_copy">
			<div class="container">
				<div class="row edu_copy">
					<div class="site-info col-md-8 col-sm-8 edu_left">
                		&copy; <?php echo date('Y').' '; bloginfo( 'name' ); ?>
                		<span class="sep"> | </span>
						<?php printf( esc_html__( 'Theme by %1$s.', 'educa' ),  '<a href="'.esc_url('https://www.themefarmer.com').'" rel="designer">Theme Farmer</a>' ); ?>
					</div><!-- .site-info -->
					<div class="col-md-4 col-sm-4 edu_right">
						<?php educa_get_social_block(); ?>
					</div>
				</div>
			</div>
		</div>

	</footer>
	<a href="#" class="scroll_top" title="<?php _e('Go Top','educa');?>"><i class="fa fa-angle-up"></i></a>
	<!-- Footer End -->
	
	
</div><!-- #page -->
<?php wp_footer(); ?>

</body>
</html>
