<?php
/**
 * The template part for Top Header
 *
 * @package Ecommerce Watch Store  
 * @subpackage ecommerce-watch-store
 * @since ecommerce-watch-store 1.0
 */
?>
<!-- Top Header -->
<?php if( get_theme_mod( 'ecommerce_watch_store_header_topbar',true) == 1 || get_theme_mod( 'ecommerce_watch_store_resp_topbar_hide_show', true) == 1) { ?>
  <div class="topbar">
    <div class="container">
      <div class="row">
        <div class="col-lg-3 col-md-3 align-self-center text-lg-start text-md-start text-center" >
          <?php if( class_exists( 'GTranslate' ) ) { ?>
            <div class="translate-lang position-relative d-md-inline-block me-3">
              <?php echo do_shortcode( '[gtranslate]' );?>
            </div>
          <?php }?>
        </div>
        <div class="col-lg-6 col-md-6 align-self-center text-center" >
          <?php if(get_theme_mod('ecommerce_watch_store_offer_text') != ''){ ?>
            <p class="topbar-text mb-lg-0 mb-md-0 mt-3 mt-md-0"><?php echo esc_html(get_theme_mod('ecommerce_watch_store_offer_text')); ?></p>
          <?php }?>
        </div>
        <div class="col-lg-3 col-md-3 align-self-center text-lg-end text-md-end text-center" >
          <div class="topbar-social-icon">
            <?php if (is_active_sidebar('slider-social')) : ?>
              <?php dynamic_sidebar('social-widget'); ?>
            <?php else : ?>
              <!-- Default Social Icons Widgets -->
                <div class="widget">
                    <ul class="custom-social-icons" >
                      <li><a href="https://facebook.com" target="_blank"><i class="fab fa-facebook"></i></a></li> 
                      <li><a href="https://twitter.com" target="_blank"><i class="fab fa-twitter"></i></a></li> 
                      <li><a href="https://instagram.com" target="_blank"><i class="fab fa-instagram"></i></a></li> 
                      <li><a href="https://linkedin.com" target="_blank"><i class="fab fa-linkedin"></i></a></li> 
                      <li><a href="https://pinterest.com" target="_blank"><i class="fab fa-pinterest"></i></a></li>  
                      <li><a href="https://youtube.com" target="_blank"><i class="fab fa-youtube"></i></a></li>                  
                    </ul>
                </div>
            <?php endif; ?>     
          </div>
        </div>
      </div>
    </div>
  </div>
<?php }?>