<div class="theme-offer">
	<?php 
        // Check if the demo import has been completed
        $demo_import_completed = get_option('ecommerce_watch_store_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'ecommerce-watch-store') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'ecommerce-watch-store') . '</a></span>';
        }

		// POST and update the customizer and other related data
        if (isset($_POST['submit'])) {
            // Check if Contact Form 7 is installed and activated
            if (!is_plugin_active('woocommerce/woocommerce.php')) {
              // Install the plugin if it doesn't exist
              $ecommerce_watch_store_plugin_slug = 'woocommerce';
              $ecommerce_watch_store_plugin_file = 'woocommerce/woocommerce.php';

              // Check if plugin is installed
              $installed_plugins = get_plugins();
              if (!isset($installed_plugins[$ecommerce_watch_store_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $ecommerce_watch_store_upgrader = new Plugin_Upgrader();
                  $ecommerce_watch_store_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($ecommerce_watch_store_plugin_file);
            }

            // Check if  GTranslate is installed and activated
            if (!is_plugin_active('gtranslate/gtranslate.php')) {
              // Install the plugin if it doesn't exist
              $ecommerce_watch_store_plugin_slug = 'gtranslate';
              $ecommerce_watch_store_plugin_file = 'gtranslate/gtranslate.php';

              // Check if plugin is installed
              $ecommerce_watch_store_installed_plugins = get_plugins();
              if (!isset($ecommerce_watch_store_installed_plugins[$ecommerce_watch_store_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $ecommerce_watch_store_upgrader = new Plugin_Upgrader();
                  $ecommerce_watch_store_upgrader->install('https://downloads.wordpress.org/plugin/gtranslate.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($ecommerce_watch_store_plugin_file);
            }

            // Create a front page and assign the template
            $ecommerce_watch_store_home_page = null;
            // Using WP_Query instead of get_page_by_title()
            $ecommerce_watch_store_home_query = new WP_Query(array(
               'post_type' => 'page',
               'title' => 'Home',
               'post_status' => 'publish',
               'posts_per_page' => 1
            ));
            if (!$ecommerce_watch_store_home_query->have_posts()) {
               $ecommerce_watch_store_home_title = 'Home';           
               // Create the page
               $ecommerce_watch_store_home = array(
                   'post_type' => 'page',
                   'post_title' => $ecommerce_watch_store_home_title,
                   'post_status' => 'publish',
                   'post_author' => 1,
                   'post_slug' => 'home'
               );
               $ecommerce_watch_store_home_id = wp_insert_post($ecommerce_watch_store_home);
            } else {
               $ecommerce_watch_store_home_page = $ecommerce_watch_store_home_query->posts[0];
               $ecommerce_watch_store_home_id = $ecommerce_watch_store_home_page->ID;
            }

            // Set the home page template
            add_post_meta($ecommerce_watch_store_home_id, '_wp_page_template', 'page-template/custom-home-page.php');

            // Set the static front page
            update_option('page_on_front', $ecommerce_watch_store_home_id);
            update_option('show_on_front', 'page');

            // Create another page if needed
            $ecommerce_watch_store_page_query = new WP_Query(array(
               'post_type' => 'page',
               'title' => 'Page',
               'post_status' => 'publish',
               'posts_per_page' => 1
            ));

            if (!$ecommerce_watch_store_page_query->have_posts()) {
               $ecommerce_watch_store_page_title = 'Page';
               $ecommerce_watch_store_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                    There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                    All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
               
                $ecommerce_watch_store_page = array(
                   'post_type' => 'page',
                   'post_title' => $ecommerce_watch_store_page_title,
                   'post_content' => $ecommerce_watch_store_content,
                   'post_status' => 'publish',
                   'post_author' => 1,
                   'post_slug' => 'page'
                );
                $ecommerce_watch_store_page_id = wp_insert_post($ecommerce_watch_store_page);
            }       

            // Top Bar //
            set_theme_mod( 'ecommerce_watch_store_location', '745 Adelaide Street, Tokto' ); 
            set_theme_mod( 'ecommerce_watch_store_location_icon', 'fas fa-map-marker-alt' );
            set_theme_mod( 'ecommerce_watch_store_phone_number', '+00 123 456 7890' ); 
            set_theme_mod( 'ecommerce_watch_store_phone_number_icon', 'fa fa-phone' );
            set_theme_mod( 'ecommerce_watch_store_lite_email', 'xyz123@example.com' ); 
            set_theme_mod( 'ecommerce_watch_store_email_icon', 'fas fa-envelope' );    
            set_theme_mod( 'ecommerce_watch_store_topbar_button_label', 'Book A Consultation' ); 
            set_theme_mod( 'ecommerce_watch_store_topbar_button_url', '#' );   
            set_theme_mod( 'ecommerce_watch_store_button_icon', 'fas fa-angle-right' ); 
        
            // Set the demo import completion flag
    		update_option('ecommerce_watch_store_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'ecommerce-watch-store') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'ecommerce-watch-store') . '</a></span>';

            //end 

            // Topbar start //
            set_theme_mod( 'ecommerce_watch_store_offer_text', 'FREE SHIPPING WORLDWIDE' );

            // slider section start //  
            set_theme_mod('ecommerce_watch_store_slider_hide_show', 1);
            set_theme_mod( 'ecommerce_watch_store_banner_image', get_template_directory_uri().'/assets/images/banner.png' );       
            set_theme_mod( 'ecommerce_watch_store_banner_tagline_title', 'Latest Watch Collection' );
            set_theme_mod( 'ecommerce_watch_store_banner_para_text', 'Raymond Weil’s emblematic collection, nabucco, makes a strong come back this year.' );
            set_theme_mod( 'ecommerce_watch_store_slider_button_text', 'EXPLORE NOW' );
            set_theme_mod( 'ecommerce_watch_store_slider_button_url', '#' );
            set_theme_mod( 'ecommerce_watch_store_product_category', 'productcategory1' );

            $ecommerce_watch_store_category_names = array('productcategory1');
            $ecommerce_watch_store_title_array = array(
                array("Sports Multi-function Electronic Watch", "boAt Storm Infinity Smart Watch", "BEN NEVIS Watch", "Sports Multi-function Electronic Watch")
                
            );

            foreach ($ecommerce_watch_store_category_names as $ecommerce_watch_store_index => $ecommerce_watch_store_category_name) {
                // Create or retrieve the product category term ID
                $ecommerce_watch_store_term = term_exists($ecommerce_watch_store_category_name, 'product_cat');
                if ($ecommerce_watch_store_term === 0 || $ecommerce_watch_store_term === null) {
                    // If the term does not exist, create it
                    $ecommerce_watch_store_term = wp_insert_term($ecommerce_watch_store_category_name, 'product_cat');
                }

                if (is_wp_error($ecommerce_watch_store_term)) {
                    error_log('Error creating category: ' . $ecommerce_watch_store_term->get_error_message());
                    continue; // Skip to the next iteration if category creation fails
                }

                // Loop to create 4 products for each category
                for ($ecommerce_watch_store_i = 0; $ecommerce_watch_store_i < 4; $ecommerce_watch_store_i++) {
                    // Create product content
                    $ecommerce_watch_store_title = $ecommerce_watch_store_title_array[$ecommerce_watch_store_index][$ecommerce_watch_store_i];
                    $ecommerce_watch_store_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';

                    // Create product post object
                    $ecommerce_watch_store_my_post = array(
                        'post_title'    => wp_strip_all_tags($ecommerce_watch_store_title),
                        'post_content'  => $ecommerce_watch_store_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'product', // Post type set to 'product'
                    );

                    // Insert the product into the database
                    $ecommerce_watch_store_post_id = wp_insert_post($ecommerce_watch_store_my_post);

                    update_post_meta($ecommerce_watch_store_post_id, 'ecommerce_watch_store_brand_name', 'Brand Name Here');

                    if (is_wp_error($ecommerce_watch_store_post_id)) {
                        error_log('Error creating product: ' . $ecommerce_watch_store_post_id->get_error_message());
                        continue; // Skip to the next product if creation fails
                    }

                    // Assign the category to the product
                    wp_set_object_terms($ecommerce_watch_store_post_id, (int)$ecommerce_watch_store_term['term_id'], 'product_cat');

                    // Add product meta (price, etc.)
                    
                    update_post_meta($ecommerce_watch_store_post_id, '_sale_price', '90.99'); // Sale price
                    update_post_meta($ecommerce_watch_store_post_id, '_price', '90.99'); // Active price

                    // Handle the featured image using media_sideload_image
                    $ecommerce_watch_store_image_url = get_template_directory_uri() . '/assets/images/watch' . ($ecommerce_watch_store_i + 1) . '.png';
                    $ecommerce_watch_store_image_id = media_sideload_image($ecommerce_watch_store_image_url, $ecommerce_watch_store_post_id, null, 'id');

                    if (is_wp_error($ecommerce_watch_store_image_id)) {
                        error_log('Error downloading image: ' . $ecommerce_watch_store_image_id->get_error_message());
                        continue; // Skip to the next product if image download fails
                    }

                    // Assign featured image to product
                    set_post_thumbnail($ecommerce_watch_store_post_id, $ecommerce_watch_store_image_id);

                }
            }

            // product section
            set_theme_mod( 'ecommerce_watch_store_product_heading_product', 'Universal Timekeepers of the world' );
            set_theme_mod( 'ecommerce_watch_store_featured_text', 'FEATURED' );
            set_theme_mod( 'ecommerce_watch_store_best_selling_text', 'BEST SELLING' );
            set_theme_mod( 'ecommerce_watch_store_new_arrival_text', 'NEW ARRIVALS' );
            set_theme_mod( 'ecommerce_watch_store_on_sale_text', 'ON SALE' );
            
        }
    ?>
  
	
    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=ecommerce_watch_store_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('ecommerce_watch_store_demo_import_completed')) : ?>
            <form method="post">
                <p class="run-import-text"><?php esc_html_e('Click On The Below Run Importer Button To Import Demo Content Of Ecommerce Watch Store','ecommerce-watch-store'); ?></p>
                <p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for Ecommerce Watch Store', 'ecommerce-watch-store'); ?></p>
                <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','ecommerce-watch-store'); ?>" class="button button-primary button-large">
            </form>
        <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
			 if(confirm("Do you really want to import the theme demo content?")){
                // Show loader
                document.getElementById('demo-import-loader').style.display = 'block';
                // Submit form
			    document.forms[0].submit();
			}
		    else {
			    return false;
		    }
		}
	</script>
</div>

