( function( api ) {

	// Extends our custom "ecommerce-solution" section.
	api.sectionConstructor['ecommerce-solution'] = api.Section.extend( {

		// No events for this type of section.
		attachEvents: function () {},

		// Always make the section active.
		isContextuallyActive: function () {
			return true;
		}
	} );

} )( wp.customize );

(function ($) {
    function ResetDemoSettings() {
        if (!confirm("Are you sure you want to reset demo import settings?")) return;

        $.post(ajaxurl, { action: 'ecommerce_solution_reset_demo_import_settings' }, function () {
            location.reload();
        });
    }

    window.ResetDemoSettings = ResetDemoSettings;
})(jQuery);

(function ($, wp) {
    function ResetGlobalColor() {
        if (confirm("Are you sure you want to reset global color settings?")) {
            wp.customize.instance("ecommerce_solution_first_color").set("#ffca04");
        }
    }

    window.ResetGlobalColor = ResetGlobalColor;
})(jQuery, wp);