<?php
add_action( 'admin_menu', 'ecommerce_solution_gettingstarted' );
function ecommerce_solution_gettingstarted() {
	add_theme_page( esc_html__('About Theme', 'ecommerce-solution'), esc_html__('Theme Demo Import', 'ecommerce-solution'), 'edit_theme_options', 'ecommerce-solution-guide-page', 'ecommerce_solution_guide');
}

function ecommerce_solution_admin_theme_style() {
   wp_enqueue_style('ecommerce-solution-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/dashboard/get_started_info.css');
   wp_enqueue_script('ecommerce_solution-tab', esc_url( get_template_directory_uri() ) . '/inc/dashboard/js/get_started_tab.js');
   // Admin notice code START
	wp_register_script('ecommerce-solution-notice', esc_url(get_template_directory_uri()) . '/inc/dashboard/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('ecommerce-solution-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'ecommerce_solution_admin_theme_style');

// Notice after Theme Activation
function ecommerce_solution_notice(){
    global $pagenow;
    if ( is_admin() && $pagenow === 'themes.php' && (!isset($_GET['page']) || $_GET['page'] !== 'ecommerce-solution-guide-page')
) {
$ecommerce_solution_meta = get_option( 'ecommerce_solution_admin_notice' );
	if (!$ecommerce_solution_meta) {?>
    <div id="ecommerce-solution-welcome-notice" class="notice notice-success is-dismissible getting_started activation-notice">
		<div class="notice-info">
			<div class="notice-image">
				<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
			</div>
			<div class="notice-content">
				<h2><?php esc_html_e( 'Thanks For Installing Ecommerce Solution, You Rock!', 'ecommerce-solution' ) ?> </h2>
				<p><?php esc_html_e( 'Take benefit of a variety of features, functionalities, elements, and an exclusive set of customization options to build your own professional charity website. Please Click on the link below to know the theme setup information.', 'ecommerce-solution' ) ?></p>
				<div style="display: grid;">
					<a class="button notice-btn" href="<?php echo esc_url( admin_url( 'themes.php?page=ecommerce-solution-guide-page' )); ?>"><?php esc_html_e( 'Get Started', 'ecommerce-solution' ) ?></a>
					<a class="button notice-btn" target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_LIVE_DEMO ); ?>"><?php esc_html_e('Pro Demo', 'ecommerce-solution') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_BUY_PRO ); ?>"><?php esc_html_e('Upgrade To Pro', 'ecommerce-solution') ?></a>
					<a  class="button notice-btn" target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_FREE_DOC ); ?>"><?php esc_html_e('Free Doc', 'ecommerce-solution') ?></a>
				</div>

			</div>
		</div>
	</div>
	<?php }
}
}
add_action('admin_notices', 'ecommerce_solution_notice');

// Admin notice code START
function ecommerce_solution_dismissed_notice() {
	update_option( 'ecommerce_solution_admin_notice', true );
}
add_action( 'wp_ajax_ecommerce_solution_dismissed_notice', 'ecommerce_solution_dismissed_notice' );

//After Switch theme function
add_action('after_switch_theme', 'ecommerce_solution_getstart_setup_options');
function ecommerce_solution_getstart_setup_options () {
    update_option('ecommerce_solution_admin_notice', false );
}
// Admin notice code END

/**
 * Theme Info Page
 */
function ecommerce_solution_guide() {

	// Theme info
	$ecommerce_solution_return = add_query_arg( array()) ;
	$ecommerce_solution_theme = wp_get_theme( 'ecommerce-solution' ); ?>

	<div class="wrap getting-started">
		<div class="getting-started__header">
		    <div>
                <h2 class="tgmpa-notice-warning"></h2>
            </div>
		</div>
		<div class="tab-sec">
			<div class="tab">
				<button role="tab" class="tablinks home" onclick="ecommerce_solution_openCity(event, 'bwp_getstart')"><?php esc_html_e( 'Theme Demo Import', 'ecommerce-solution' ); ?></button>
				<button role="tab" class="tablinks" onclick="ecommerce_solution_openCity(event, 'bwp_setup')"><?php esc_html_e( 'Free Theme Information', 'ecommerce-solution' ); ?></button>
				<button role="tab" class="tablinks" onclick="ecommerce_solution_openCity(event, 'bwp_premium_info')"><?php esc_html_e( 'Premium Theme Information', 'ecommerce-solution' ); ?></button>
				<a class="tablinks tablinks-demo" role="tab" href="<?php echo esc_url( ECOMMERCE_SOLUTION_LIVE_DEMO ); ?>" target="_blank">
					<?php esc_html_e( 'Live Demo', 'ecommerce-solution' ); ?>
				</a>
				<a class="tablinks tablinks-pro" role="tab" href="<?php echo esc_url( ECOMMERCE_SOLUTION_BUY_PRO ); ?>" target="_blank">
					<?php esc_html_e( 'Buy Pro', 'ecommerce-solution' ); ?>
				</a>
			</div>
			<div  id="bwp_getstart" class="tabcontent">
				<div class="row">
					<div class="col-md-5 intro">
						<div class="pad-box">
							<h2><?php esc_html_e( 'Welcome to Ecommerce Solution ', 'ecommerce-solution' ); ?>
							<span><?php esc_html_e( 'Version: ', 'ecommerce-solution' ); ?><?php echo esc_html($ecommerce_solution_theme['Version']);?></span>
							</h2>
							<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'ecommerce-solution' ); ?>
							</span>
							<div class="powered-by">
								<p><strong><?php esc_html_e( 'Theme created by Buy WP Templates', 'ecommerce-solution' ); ?></strong></p>
								<p>
									<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/theme-logo.png'); ?>"/>
								</p>
								<div class="demo-content">
									<?php
										/* Demo Import */
										require get_parent_theme_file_path( '/inc/dashboard/demo-content.php' );
									?>
								</div>

								<div id="demo-import-loader">
									<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/spinner.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'ecommerce-solution'); ?>" />
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-7">
						<div class="install-plugins">
							<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive1.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'ecommerce-solution'); ?>" />
						</div>
					</div>
				</div>
				<div class="dashboard__blocks">
					<div class="row">
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Get Support','ecommerce-solution'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_FREE_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','ecommerce-solution'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','ecommerce-solution'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Getting Started','ecommerce-solution'); ?></h3>
							<ol>
								<li><?php esc_html_e( 'Start','ecommerce-solution'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','ecommerce-solution'); ?></a> <?php esc_html_e( 'your website.','ecommerce-solution'); ?> </li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Help Docs','ecommerce-solution'); ?></h3>
							<ol>
								<li><a target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_FREE_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','ecommerce-solution'); ?></a></li>
								<li><a target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','ecommerce-solution'); ?></a></li>
							</ol>
						</div>
						<div class="col-md-3">
							<h3><?php esc_html_e( 'Buy Premium','ecommerce-solution'); ?></h3>
							<ol>
								<a href="<?php echo esc_url( ECOMMERCE_SOLUTION_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'ecommerce-solution'); ?></a>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<div  id="bwp_setup" class="tabcontent">
				<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup Ecommerce Solution Theme', 'ecommerce-solution' ); ?></h2>
				<div class="row">
					<div class="theme-instruction-block col-md-7">
						<div class="pad-box">
							<p><?php esc_html_e('Ecommerce Solution is a multipurpose, clean, and polished theme designed to build a powerful online store and create an impactful digital shopping experience. Perfect for online apparel stores, fashion boutiques, sports shops, cosmetics stores, food and grocery markets, furniture shops, toy stores, jewelry boutiques, electronic gadget shops, and multi-vendor marketplaces, it offers complete flexibility for every type of eCommerce business. The theme includes banners and sliders to showcase featured products and promote top brands, along with options for customizable layouts, product grids, blog settings, color schemes, and full-width templates. Built with the WooCommerce plugin for seamless online store management, it enables smooth product listings, cart management, and secure checkout. Additional features include a slider section, sidebar layouts, logo resizer, footer customization, call-to-action buttons, icon changer, and background skin options for better visual appeal. The theme is responsive, cross-browser compatible, multilingual, and SEO-optimized, ensuring high performance across all devices and search engines. With built-in Bootstrap framework support, flexible widget areas, and compatibility with third-party plugins, Ecommerce Solution provides an ideal foundation for creating fashion stores, online supermarkets, affiliate stores, digital marketplaces, and multi-vendor platforms with ease and professional design quality.', 'ecommerce-solution' ); ?><p><br>
							<ol>
								<li><?php esc_html_e( 'Start','ecommerce-solution'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','ecommerce-solution'); ?></a> <?php esc_html_e( 'your website.','ecommerce-solution'); ?> </l>
								<li><?php esc_html_e( 'Ecommerce Solution','ecommerce-solution'); ?> <a target="_blank" href="<?php echo esc_url( ECOMMERCE_SOLUTION_FREE_DOC ); ?>"><?php esc_html_e( 'Documentation','ecommerce-solution'); ?></a> </li>
							</ol>
						</div>
					</div>
					<div class="col-md-5">
						<div class="pad-box">
								<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/screenshot.png'); ?>"/>
						</div>
					</div>	
				</div>
			</div>
			<div class="col-md-12 text-block tabcontent"  id="bwp_premium_info">
				<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','ecommerce-solution'); ?></h2>
				<div class="row">
					<div class="col-md-7">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/dashboard/media/responsive.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'ecommerce-solution'); ?>">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Description','ecommerce-solution'); ?></h3>
							<p class="pad-box-p"><?php esc_html_e( 'Ecommerce WordPress theme is creative, stylish, dynamic and stunning. It is made to serve all range of businesses from a small local grocery shop to a giant multipurpose retail chain. It is backed by multiple page and blog layouts, unlimited colours and numerous Google fonts to craft out a website of your desired look and feel within minutes of installing it. It keeps you away from the stress of coding as it is extremely easy to use and manage for webmasters and novice both. It is strengthened by WooCommerce plugin which sets up a beautiful platform to sell anything. This plugin is the soul of any eCommerce website and gives immense power to you to sell both physical as well as digital goods in many shop layouts. With so many tools and features working on your behalf, this eCommerce WordPress theme will take care of everything and will free you from tons of responsibilities that come with a website. It provides a vast additional space in the form of banner and sliders to show your uniqueness in decorating it impressively. Get priority fixing of errors with the premium membership provided with the theme.', 'ecommerce-solution' ); ?><p>
						</div>
					</div>
					<div class="col-md-5 install-plugin-right">
						<div class="pad-box">
							<h3><?php esc_html_e( 'Pro Theme Features','ecommerce-solution'); ?></h3>
							<div class="dashboard-install-benefit">
								<ul>
									<li><?php esc_html_e( 'Theme options using customizer API','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Responsive design','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Favicon, Logo, title and tagline customization','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Advanced Color options and color pallets','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( '100+ Font Family Options','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Pagination option','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Fade Slider With different Tabs','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Unlimited Slides','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'About the Company section','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Services Listing','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Form to get a Free quote using Contact Form 7','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Pricing Plans section','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Seperate section to defind the flow of work','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Testimonial Section with shortcode','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'FAQ Section on Home with its shortcode','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Brand/Partner Listing Section','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Social Icon Widget, tagline, logo.','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Social Sharing On post','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Well sanitized as per WordPress standards.','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Responsive layout for all devices','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Fully integrated with Font Awesome Icon','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Background Image Option','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Custom page templates','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Allow to set site title, tagline, logo','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Left and Right Sidebar','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Sticky post & Comment threads','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Customizable Home Page','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Multiple inner page templates','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Contact Page Template','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Blog Full width and right and left sidebar','ecommerce-solution'); ?></li>
									<li><?php esc_html_e( 'Recent post widget with images, Related post','ecommerce-solution'); ?></li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php }?>
