<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $ecommerce_solution_demo_import_completed = get_option('ecommerce_solution_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($ecommerce_solution_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'ecommerce-solution') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'ecommerce-solution') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

            // Check if Contact Form 7 is installed and activated
            if (!is_plugin_active('woocommerce/woocommerce.php')) {
              // Install the plugin if it doesn't exist
              $ecommerce_solution_plugin_slug = 'woocommerce';
              $ecommerce_solution_plugin_file = 'woocommerce/woocommerce.php';

              // Check if plugin is installed
              $ecommerce_solution_installed_plugins = get_plugins();
              if (!isset($ecommerce_solution_installed_plugins[$ecommerce_solution_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $ecommerce_solution_upgrader = new Plugin_Upgrader();
                  $ecommerce_solution_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($ecommerce_solution_plugin_file);
            }

            // ------- Create Nav Menu --------
            $ecommerce_solution_menuname = 'Primary Menu';
            $ecommerce_solution_bpmenulocation = 'primary';
            $ecommerce_solution_menu_exists = wp_get_nav_menu_object($ecommerce_solution_menuname);

            if (!$ecommerce_solution_menu_exists) {
                $ecommerce_solution_menu_id = wp_create_nav_menu($ecommerce_solution_menuname);

                // Create Home Page
                $ecommerce_solution_home_title = 'Home';
                $ecommerce_solution_home = array(
                    'post_type' => 'page',
                    'post_title' => $ecommerce_solution_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $ecommerce_solution_home_id = wp_insert_post($ecommerce_solution_home);
                // Assign Home Page Template
                add_post_meta($ecommerce_solution_home_id, '_wp_page_template', 'page-template/home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $ecommerce_solution_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'ecommerce-solution'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create page Us Page with Dummy Content
                $ecommerce_solution_about_title = 'About Us';
                $ecommerce_solution_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $ecommerce_solution_about = array(
                    'post_type' => 'page',
                    'post_title' => $ecommerce_solution_about_title,
                    'post_content' => $ecommerce_solution_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $ecommerce_solution_about_id = wp_insert_post($ecommerce_solution_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'ecommerce-solution'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                
                // Create Pages Page with Dummy Content
                $ecommerce_solution_page_title = 'Pages';
                $ecommerce_solution_page_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>
                Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>
                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>
                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $ecommerce_solution_page = array(
                    'post_type' => 'page',
                    'post_title' => $ecommerce_solution_page_title,
                    'post_content' => $ecommerce_solution_page_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'page'
                );
                $ecommerce_solution_page_id = wp_insert_post($ecommerce_solution_page);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'ecommerce-solution'),
                    'menu-item-classes' => 'page-us',
                    'menu-item-url' => home_url('/page/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_page_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Mobile Page
                $ecommerce_solution_mobile_title = 'Mobile';
                $ecommerce_solution_mobile_content = 'Explore our Mobile collection.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

                $ecommerce_solution_mobile = array(
                    'post_type'   => 'page',
                    'post_title'  => $ecommerce_solution_mobile_title,
                    'post_content'=> $ecommerce_solution_mobile_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug'   => 'mobile'
                );
                $ecommerce_solution_mobile_id = wp_insert_post($ecommerce_solution_mobile);

                // Add Mobile Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Mobile', 'ecommerce-solution'),
                    'menu-item-classes' => 'mobile',
                    'menu-item-url' => home_url('/mobile/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_mobile_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Headphone Page
                $ecommerce_solution_headphone_title = 'Headphone';
                $ecommerce_solution_headphone_content = 'Browse premium Headphones.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

                $ecommerce_solution_headphone = array(
                    'post_type'   => 'page',
                    'post_title'  => $ecommerce_solution_headphone_title,
                    'post_content'=> $ecommerce_solution_headphone_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug'   => 'headphone'
                );
                $ecommerce_solution_headphone_id = wp_insert_post($ecommerce_solution_headphone);

                // Add Headphone Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Headphone', 'ecommerce-solution'),
                    'menu-item-classes' => 'headphone',
                    'menu-item-url' => home_url('/headphone/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_headphone_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Clothes Page
                $ecommerce_solution_clothes_title = 'Clothes';
                $ecommerce_solution_clothes_content = 'Discover trendy Clothes.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

                $ecommerce_solution_clothes = array(
                    'post_type'   => 'page',
                    'post_title'  => $ecommerce_solution_clothes_title,
                    'post_content'=> $ecommerce_solution_clothes_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug'   => 'clothes'
                );
                $ecommerce_solution_clothes_id = wp_insert_post($ecommerce_solution_clothes);

                // Add Clothes Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Clothes', 'ecommerce-solution'),
                    'menu-item-classes' => 'clothes',
                    'menu-item-url' => home_url('/clothes/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_clothes_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Shoes Page
                $ecommerce_solution_shoes_title = 'Shoes';
                $ecommerce_solution_shoes_content = 'Shop stylish Shoes.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

                $ecommerce_solution_shoes = array(
                    'post_type'   => 'page',
                    'post_title'  => $ecommerce_solution_shoes_title,
                    'post_content'=> $ecommerce_solution_shoes_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug'   => 'shoes'
                );
                $ecommerce_solution_shoes_id = wp_insert_post($ecommerce_solution_shoes);

                // Add Shoes Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Shoes', 'ecommerce-solution'),
                    'menu-item-classes' => 'shoes',
                    'menu-item-url' => home_url('/shoes/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_shoes_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                // Create Watches Page
                $ecommerce_solution_watches_title = 'Watches';
                $ecommerce_solution_watches_content = 'Explore modern Watches.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit.';

                $ecommerce_solution_watches = array(
                    'post_type'   => 'page',
                    'post_title'  => $ecommerce_solution_watches_title,
                    'post_content'=> $ecommerce_solution_watches_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug'   => 'watches'
                );
                $ecommerce_solution_watches_id = wp_insert_post($ecommerce_solution_watches);

                // Add Watches Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Watches', 'ecommerce-solution'),
                    'menu-item-classes' => 'watches',
                    'menu-item-url' => home_url('/watches/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_watches_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Blogs Page with Dummy Content
                $ecommerce_solution_blogs_title = 'Blogs';
                $ecommerce_solution_blogs_content = 'Read our latest blog posts.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
                $ecommerce_solution_blogs = array(
                    'post_type' => 'page',
                    'post_title' => $ecommerce_solution_blogs_title,
                    'post_content' => $ecommerce_solution_blogs_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'blogs'
                );
                $ecommerce_solution_blogs_id = wp_insert_post($ecommerce_solution_blogs);
                // Add Blogs Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Blogs', 'ecommerce-solution'),
                    'menu-item-classes' => 'blogs',
                    'menu-item-url' => home_url('/blogs/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_blogs_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Contact Us Page with Dummy Content
                $ecommerce_solution_contact_title = 'Contact Us';
                $ecommerce_solution_contact_content = 'Get in touch with us.
                Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
                $ecommerce_solution_contact = array(
                    'post_type' => 'page',
                    'post_title' => $ecommerce_solution_contact_title,
                    'post_content' => $ecommerce_solution_contact_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'contact-us'
                );
                $ecommerce_solution_contact_id = wp_insert_post($ecommerce_solution_contact);
                // Add Contact Us Page to Menu
                wp_update_nav_menu_item($ecommerce_solution_menu_id, 0, array(
                    'menu-item-title' => __('Contact Us', 'ecommerce-solution'),
                    'menu-item-classes' => 'contact-us',
                    'menu-item-url' => home_url('/contact-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $ecommerce_solution_contact_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));
                // Set the menu location if it's not already set
                if (!has_nav_menu($ecommerce_solution_bpmenulocation)) {
                    $ecommerce_solution_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($ecommerce_solution_locations)) {
                        $ecommerce_solution_locations = array();
                    }
                    $ecommerce_solution_locations[$ecommerce_solution_bpmenulocation] = $ecommerce_solution_menu_id;
                    set_theme_mod('nav_menu_locations', $ecommerce_solution_locations);
                }
            }

            // ------- Create Top Menu --------
            $ecommerce_solution_topmenuname = 'Top Menu';
            $ecommerce_solution_topbpmenulocation = 'topmenus';
            $ecommerce_solution_topmenu_exists = wp_get_nav_menu_object($ecommerce_solution_topmenuname);

            if (!$ecommerce_solution_topmenu_exists) {
                 $ecommerce_solution_topmenu_id = wp_create_nav_menu($ecommerce_solution_topmenuname);

                 // Create Headphone Page with Dummy Content
                 $ecommerce_solution_support_title = 'Support';
                 $ecommerce_solution_support_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
                 $ecommerce_solution_support = array(
                     'post_type' => 'page',
                     'post_title' => $ecommerce_solution_support_title,
                     'post_content' => $ecommerce_solution_support_content,
                     'post_status' => 'publish',
                     'post_author' => 1,
                     'post_slug' => 'support'
                 );
                 $ecommerce_solution_topsupport_id = wp_insert_post($ecommerce_solution_support);
                 // Add Headphone Page to Menu
                 wp_update_nav_menu_item($ecommerce_solution_topmenu_id, 0, array(
                     'menu-item-title' => __('Support', 'ecommerce-solution'),
                     'menu-item-classes' => 'support',
                     'menu-item-url' => home_url('/support/'),
                     'menu-item-status' => 'publish',
                     'menu-item-object-id' => $ecommerce_solution_topsupport_id,
                     'menu-item-object' => 'page',
                     'menu-item-type' => 'post_type'
                 ));

                  // Create Headphone Page with Dummy Content
                  $ecommerce_solution_store_title = 'Store Locator';
                  $ecommerce_solution_store_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
                  $ecommerce_solution_store = array(
                      'post_type' => 'page',
                      'post_title' => $ecommerce_solution_store_title,
                      'post_content' => $ecommerce_solution_store_content,
                      'post_status' => 'publish',
                      'post_author' => 1,
                      'post_slug' => 'store'
                  );
                  $ecommerce_solution_topstore_id = wp_insert_post($ecommerce_solution_store);
                  // Add Headphone Page to Menu
                  wp_update_nav_menu_item($ecommerce_solution_topmenu_id, 0, array(
                      'menu-item-title' => __('Store Locator', 'ecommerce-solution'),
                      'menu-item-classes' => 'store',
                      'menu-item-url' => home_url('/store/'),
                      'menu-item-status' => 'publish',
                      'menu-item-object-id' => $ecommerce_solution_topstore_id,
                      'menu-item-object' => 'page',
                      'menu-item-type' => 'post_type'
                  ));

                   // Create Headphone Page with Dummy Content
                 $ecommerce_solution_free_title = 'Free Shipping';
                 $ecommerce_solution_free_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
                 $ecommerce_solution_free = array(
                     'post_type' => 'page',
                     'post_title' => $ecommerce_solution_free_title,
                     'post_content' => $ecommerce_solution_free_content,
                     'post_status' => 'publish',
                     'post_author' => 1,
                     'post_slug' => 'free'
                 );
                 $ecommerce_solution_topfree_id = wp_insert_post($ecommerce_solution_free);
                 // Add Headphone Page to Menu
                 wp_update_nav_menu_item($ecommerce_solution_topmenu_id, 0, array(
                     'menu-item-title' => __('Free Shipping', 'ecommerce-solution'),
                     'menu-item-classes' => 'free',
                     'menu-item-url' => home_url('/free/'),
                     'menu-item-status' => 'publish',
                     'menu-item-object-id' => $ecommerce_solution_topfree_id,
                     'menu-item-object' => 'page',
                     'menu-item-type' => 'post_type'
                 ));


                 // Set the menu location if it's not already set
                if (!has_nav_menu($ecommerce_solution_topbpmenulocation)) {
                    $ecommerce_solution_locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($ecommerce_solution_locations)) {
                         $ecommerce_solution_locations = array();
                    }
                    $ecommerce_solution_locations[$ecommerce_solution_topbpmenulocation] = $ecommerce_solution_topmenu_id;
                    set_theme_mod('nav_menu_locations', $ecommerce_solution_locations);
                }
            }

            // Set the demo import completion flag
    		update_option('ecommerce_solution_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'ecommerce-solution') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('VIEW SITE', 'ecommerce-solution') . '</a></span>';
            //end

            // Top Bar //
            set_theme_mod( 'ecommerce_solution_phone_number', '0123-444-666654123' );

            // slider section start //
            set_theme_mod( 'ecommerce_solution_slider_hide', true );
            set_theme_mod( 'ecommerce_solution_option_slider_height', '550' );
            set_theme_mod( 'ecommerce_solution_slider_button_text', 'SHOP NOW' );
            set_theme_mod( 'ecommerce_solution_slider_small_title', 'Lorem Ipsum is Simply' );
            set_theme_mod( 'ecommerce_solution_topbar_btn_link', 'www.example-info.com' );

            $ecommerce_solution_slider_titles = array(
                'EXPLORE THE BEST ONLINE SHOPPING EXPERIENCE', 
                'DISCOUNTED PRODUCTS WITH FAST DELIVERY', 
                'SHOP THE LATEST TRENDS AND STYLES',
                'ENJOY EXCLUSIVE DEALS AND OFFERS',  
            );
            
            for ($ecommerce_solution_i = 0; $ecommerce_solution_i < 4; $ecommerce_solution_i++) {
                // Get the slider title and content
                $ecommerce_solution_slider_title = $ecommerce_solution_slider_titles[$ecommerce_solution_i];
                $ecommerce_solution_slider_content = 'Discover the latest products at amazing prices. Fast shipping and top-quality service await you.';
            
                // Create post object
                $ecommerce_solution_my_post = array(
                    'post_title'    => wp_strip_all_tags($ecommerce_solution_slider_title),
                    'post_content'  => $ecommerce_solution_slider_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'page',
                );
            
                // Insert the post into the database
                $ecommerce_solution_post_id = wp_insert_post($ecommerce_solution_my_post);
            
                if ($ecommerce_solution_post_id) {
                    // Set the theme mod for the slider page
                    set_theme_mod('ecommerce_solution_slider_setting' . ($ecommerce_solution_i + 1), $ecommerce_solution_post_id);
            
                    // Set the slider image URL for each index
                    $ecommerce_solution_image_url = get_template_directory_uri() . '/images/slider' . ($ecommerce_solution_i + 1) . '.png';
            
                    // Download the image and set it as the featured image
                    $ecommerce_solution_image_id = media_sideload_image($ecommerce_solution_image_url, $ecommerce_solution_post_id, null, 'id');
            
                    if (!is_wp_error($ecommerce_solution_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($ecommerce_solution_post_id, $ecommerce_solution_image_id);
                    }
                }
            }

            // new collection
            set_theme_mod('ecommerce_solution_show_new_collection_section', true );
            set_theme_mod('ecommerce_solution_bestseller_section_title', 'Shop New Collection' );
            $ecommerce_solution_title_array = array(
                "Product Title 1",
                "Product Title 2",
                "Product Title 3",
                "Product Title 4",
            );
            
            for ($ecommerce_solution_i = 0; $ecommerce_solution_i < 4; $ecommerce_solution_i++) {
                // Create product content
                $ecommerce_solution_title = $ecommerce_solution_title_array[$ecommerce_solution_i];
                $ecommerce_solution_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s...';
            
                // Create product post object
                $ecommerce_solution_my_post = array(
                    'post_title'    => wp_strip_all_tags($ecommerce_solution_title),
                    'post_content'  => $ecommerce_solution_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'product', // Post type set to 'product'
                );
                // Insert the product into the database
                $ecommerce_solution_post_id = wp_insert_post($ecommerce_solution_my_post);
                if (is_wp_error($ecommerce_solution_post_id)) {
                    error_log('Error creating product: ' . $ecommerce_solution_post_id->get_error_message());
                    continue; // Skip to the next product if creation fails
                }
            
                // Assign product to the 'Uncategorized' category
                wp_set_object_terms($ecommerce_solution_post_id, 'uncategorized', 'product_cat');
            
                // Store the product ID in the theme mod settings
                set_theme_mod('ecommerce_solution_product_setting_' . $ecommerce_solution_i, $ecommerce_solution_post_id);
                update_post_meta($ecommerce_solution_post_id, '_regular_price', '50'); // Regular price
                update_post_meta($ecommerce_solution_post_id, '_sale_price', '49.99'); // Sale price
                update_post_meta($ecommerce_solution_post_id, '_price', '49.99'); // Active price
            
                // Handle the featured image using media_sideload_image
                $ecommerce_solution_image_url = get_template_directory_uri() . '/images/product' . ($ecommerce_solution_i + 1) . '.png';
                $ecommerce_solution_image_id = media_sideload_image($ecommerce_solution_image_url, $ecommerce_solution_post_id, null, 'id');
            
                if (is_wp_error($ecommerce_solution_image_id)) {
                    error_log('Error downloading image: ' . $ecommerce_solution_image_id->get_error_message());
                    continue; // Skip to the next product if image download fails
                }
                // Assign featured image to product
                set_post_thumbnail($ecommerce_solution_post_id, $ecommerce_solution_image_id);
            }
            
            $ecommerce_solution_page_query = new WP_Query(array(
                'post_type' => 'page',
                'title' => 'Products',
                'post_status' => 'publish',
                'posts_per_page' => 1
            ));
            
            if (!$ecommerce_solution_page_query->have_posts()) {
                $ecommerce_solution_page_title = 'SHOP NEW COLLECTION';
                $ecommerce_solution_productpage = '[products limit="4" columns="4"]';
            
                // Append the WooCommerce products shortcode to the content
                $ecommerce_solution_content = '';
                $ecommerce_solution_content .= do_shortcode($ecommerce_solution_productpage);
            
                // Create the new page
                $ecommerce_solution_page = array(
                    'post_type'    => 'page',
                    'post_title'   => $ecommerce_solution_page_title,
                    'post_content' => $ecommerce_solution_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'products'
                );
                // Insert the page and get its ID
                $ecommerce_solution_page_id = wp_insert_post($ecommerce_solution_page);
            
                // Store the page URL and ID in theme mod
                if (!is_wp_error($ecommerce_solution_page_id)) {
                    $ecommerce_solution_page_url = get_permalink($ecommerce_solution_page_id);
                    set_theme_mod('ecommerce_solution_product_settings', $ecommerce_solution_page_id); // Store ID instead of URL
                }
            }            

            //Copyright Text
            set_theme_mod( 'ecommerce_solution_footer_text', 'By Buywptemplate' );
        }
    ?>

    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=ecommerce-solution-guide-page" method="POST" onsubmit="return validate(this);">
    <?php if (!get_option('ecommerce_solution_demo_import_completed')) : ?>
        <div class="demo-btn">
        <h3><?php esc_html_e( 'Click the below run importer button to import demo content', 'ecommerce-solution' ); ?></h3>
        <form method="post">
            <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','ecommerce-solution'); ?>" class="button button-primary button-large">
        </form>
        </div>
    <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
            if ( confirm("Do you really want to import the theme demo content?")) {
                // Show loader
                document.getElementById('demo-import-loader').style.display = 'block';
                
                // Submit form
                document.forms[0].submit();
            } else {
                return false;
            }
		}
	</script>
</div>
