<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Ecommerce_Gigs
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'default-padding'); ?>>
	<?php ecommerce_gigs_post_thumbnail(); ?>
    <div class="post-content">
        <header class="entry-header">
            <h3 class="entry-title">
                <a href="<?php the_permalink();?>"><?php the_title();?></a>
            </h3>
        </header>
        <div class="entry-meta">
        	<?php ecommerce_gigs_category();
        	ecommerce_gigs_posted_on(); ?>

        </div>
        <div class="entry-content">
            <?php the_excerpt();?>
            <?php $archive_button_title = ecommerce_gigs_get_option('archive_button_title'); 
            if ( !empty( $archive_button_title ) ): ?>
                <a href="<?php the_permalink();?>" class="read-more-btn"><?php echo esc_html( $archive_button_title );?></a>
            <?php endif; ?>
        </div>
        <div class="entry-meta">
        	<?php ecommerce_gigs_posted_by(); ?>
        </div>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
