<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Ecommerce_Gigs
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'featured-post' ); ?>>
    <?php ecommerce_gigs_post_thumbnail(); ?>
    <div class="post-content">
        <?php ecommerce_gigs_title(); ?>
        <?php 
            global $post;
            $enable_post_meta = get_post_meta( $post->ID, 'enable_post_meta', true );  
            if ( !empty( $enable_post_meta || ! $enable_post_meta == '' ) ){
                if ( $enable_post_meta == 'yes' ){ 
                    echo '<div class="entry-meta">';                
                        $enable_single_date = ecommerce_gigs_get_option('enable_single_date');
                        if ( true == $enable_single_date ){
                            ecommerce_gigs_posted_on();
                        } 
                    echo '</div>';
                }
            }else { 
                echo '<div class="entry-meta">';                 
                    $enable_single_date = ecommerce_gigs_get_option('enable_single_date');
                    if ( true == $enable_single_date ){
                        ecommerce_gigs_posted_on();
                    } 
                echo '</div>';
            } ?>       
        <div class="entry-content">
            <?php the_content(); ?>
            <?php wp_link_pages( array(
                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ecommerce-gigs' ),
                'after'  => '</div>',
            ) );?>
        </div>
        <?php 
        global $post;
        $enable_post_meta = get_post_meta( $post->ID, 'enable_post_meta', true );  
        if ( !empty( $enable_post_meta || ! $enable_post_meta == '' ) ){
            if ( $enable_post_meta == 'yes' ){ 
                echo '<div class="entry-meta">';
                    $enable_single_author = ecommerce_gigs_get_option('enable_single_author');
                    if ( true == $enable_single_author ){
                        ecommerce_gigs_posted_by();
                    }                 
                echo '</div>';
            }
        }else { 
            echo '<div class="entry-meta">';
                $enable_single_author = ecommerce_gigs_get_option('enable_single_author');
                if ( true == $enable_single_author ){
                    ecommerce_gigs_posted_by();
                }                 
            echo '</div>';
        } ?>        
    </div>
</article><!-- #post-<?php the_ID(); ?> -->