<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Ecommerce_Gigs
 */

get_header();
?>
<div class="container">
    <div class="row">
		<main id="primary" <?php ecommerce_gigs_layout_classes();?> >

			<?php
			while ( have_posts() ) :
				the_post();

				get_template_part( 'template-parts/content', 'single' );

				the_post_navigation(
					array(
						'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'ecommerce-gigs' ) . '</span> <span class="nav-title">%title</span>',
						'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'ecommerce-gigs' ) . '</span> <span class="nav-title">%title</span>',
					)
				);
		    	$enable_comment = get_post_meta( $post->ID, 'enable_comment', true );  		
		    	if ( !empty( $enable_comment || ! $enable_comment == '' ) ){
		    		if ( $enable_comment == 'yes' ){ 
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
		    		}
		    	}else { 
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
		    	}


			endwhile; // End of the loop.
			?>

		</main><!-- #main -->
		<?php get_sidebar(); ?>
	</div>
</div>
<?php
get_footer();
