<?php
/**
 * Widget Load files
 *
 * @package Ecommerce_Gigs
 */

function ecommerce_gigs_widgets_scripts( $hook ) {
    if ( 'widgets.php' != $hook ) {
        return;
    }
    wp_enqueue_style( 'ecommerce-gigs-backend', get_template_directory_uri() . '/assets/css/backend.css');

    wp_enqueue_script( 'ecommerce-gigs-backend-js', get_template_directory_uri() . '/assets/js/backend.js', array( ), '20151215', true );
}
add_action( 'admin_enqueue_scripts', 'ecommerce_gigs_widgets_scripts' );

if ( class_exists( 'WooCommerce' ) ) {
	/**
	 * Featured Slider.
	 */
	require trailingslashit( get_template_directory() ). '/inc/widget/featured-slider.php';

	/**
	 * Product Tab Section.
	 */
	require trailingslashit( get_template_directory() ). '/inc/widget/product-tab.php';
	/**
	 * Product Tab and Slider Section.
	 */
	require trailingslashit( get_template_directory() ). '/inc/widget/product-tab-slider.php';	


}
/**
 * Blog Section.
 */
require trailingslashit( get_template_directory() ). '/inc/widget/blog.php';	
/**
 * Testimonial Section.
 */
require trailingslashit( get_template_directory() ). '/inc/widget/testimonial.php';	
/**
 * Client Section.
 */
require trailingslashit( get_template_directory() ). '/inc/widget/client.php';	

/**
 * Social Media Section.
 */
require trailingslashit( get_template_directory() ). '/inc/widget/social-media.php';	