<?php
/**
 * Display Testimonial Post
 *
 * @package Ecommerce_Gigs
 */

function ecommerce_gigs_action_testimonial() {
	register_widget( 'ecommerce_gigs_testimonial' );	
}
add_action( 'widgets_init', 'ecommerce_gigs_action_testimonial' );

class ecommerce_gigs_testimonial extends WP_Widget {
	
	function __construct() {
		
		global $control_ops;

		$widget_ops = array(
			'classname'   => 'latest-blog-section',
			'description' => esc_html__( 'Add Widget to Display Latest Post.', 'ecommerce-gigs' )
		);

		parent::__construct( 'ecommerce_gigs_testimonial',esc_html__( 'EG: Testimonial', 'ecommerce-gigs' ), $widget_ops, $control_ops );
	}
	function form( $instance ) {
		$defaults[ 'title' ] = esc_html__( 'Happy Customer', 'ecommerce-gigs' );
		$defaults[ 'category' ]         = '';
		$defaults[ 'number' ]   = 3;
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title           = esc_html( $instance[ 'title' ] );
		$category         = absint( $instance[ 'category' ] );
		$number   = absint( $instance[ 'number' ] );		
	?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( ' Title:', 'ecommerce-gigs' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Select Category:', 'ecommerce-gigs' ); ?></label>
			<?php
			wp_dropdown_categories(
				array(
					'show_option_none' => '',
					'show_option_all'  => esc_html__('Select','ecommerce-gigs'),
					'name'             => $this->get_field_name( 'category' ),
					'class'			   => 'widefat',	
					'name'             => esc_attr($this->get_field_name( 'category' )),
					'selected'         => absint( $category ), 
				)
			);
			?>
		</p>	

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of Products:', 'ecommerce-gigs' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" />
		</p>				
	<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'title' ]          = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'category' ]       = absint( $new_instance[ 'category' ] );
		$instance[ 'number' ] = absint( $new_instance[ 'number' ] );		
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$category        = isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : '';
		$number  = isset( $instance[ 'number' ] ) ? $instance[ 'number' ] : 3;	
		?>
		<section class="testimonial-section">
			<div class="container">
				<div class="default-padding">
					<?php if ( !empty( $title ) ): ?>
		                <header class="entry-header heading">
		                    <h2 class="entry-title">
		                       <?php echo esc_html( $title );?>
		                    </h2>
		                </header>	
	                <?php endif; ?>	

			    	<?php $args = array(
			            'posts_per_page' => absint( $number ),
			            'post_type' => 'post',
			            'post_status' => 'publish',      
			        );

			        if ( absint( $category ) > 0 ) {
			          $args['cat'] = absint( $category );
			        }

					$latest_arg = new WP_Query( $args );

					if ( $latest_arg->have_posts() ): ?>
						<div class="testimonial-slider owl-carousel owl-theme">
							<?php while ( $latest_arg->have_posts() ): $latest_arg->the_post(); 
							$image_id = get_post_thumbnail_id();
							$image_url = wp_get_attachment_image_src($image_id,'ecommerce-gigs-blog', false);
							?>
								<div class="testimonial-item">
									<div class="testimonial-content">
										<div class="entry-content">
											<span class="testimonial-quote">
                                                <i class="fa fa-quote-right"></i>
                                            </span>
											<div class="star-ratings">
												<div class="star-ratings-top" style="width: 50%;"> 
													<span>★</span>
													<span>★</span>
													<span>★</span>
													<span>★</span>
													<span>★</span>
												</div>
												<div class="star-ratings-bottom"> 
													<span>★</span>
													<span>★</span>
													<span>★</span>
													<span>★</span>
													<span>★</span>
												</div>
											</div>                                            
	                                       <?php the_excerpt(); ?>
	                                    </div>
                                        <div class="author-info">
                                            <h3 class="author-name"><?php the_title();?></h3>
                                        </div>
	                                </div>								
								</div>
							<?php endwhile; ?>
						</div>	
					<?php endif;
					wp_reset_postdata();  ?> 
				</div>
			</div>
		</section>	
		<?php 
	}	

}