<?php
/**
 * Display Featured Slider
 *
 * @package Ecommerce_Gigs
 */
function ecommerce_gigs_action_featured_slider() {
	register_widget( 'ecommerce_gigs_featured_slider' );	
}
add_action( 'widgets_init', 'ecommerce_gigs_action_featured_slider' );

class ecommerce_gigs_featured_slider extends WP_Widget {
	
	function __construct() {
		
		global $control_ops;

		$widget_ops = array(
			'classname'   => 'main-slider',
			'description' => esc_html__( 'Add Widget to Display WooCommerce Featured Slider.', 'ecommerce-gigs' )
		);

		parent::__construct( 'ecommerce_gigs_featured_slider',esc_html__( 'EG: Feature Slider', 'ecommerce-gigs' ), $widget_ops, $control_ops );
	}
	function form( $instance ) {
		$defaults[ 'button' ]           = esc_html__( 'Shop', 'ecommerce-gigs');
		$defaults[ 'button_url' ]       = '';
		$defaults[ 'category' ]         = '';
		$defaults[ 'product_number' ]   = 3;
		$defaults[ 'show_slider' ]  = true;
		$instance = wp_parse_args( (array) $instance, $defaults );

		$button            = esc_html( $instance[ 'button' ] );
		$button_url     = esc_url_raw( $instance[ 'button_url' ] );
		$category         = absint( $instance[ 'category' ] );
		$product_number   = absint( $instance[ 'product_number' ] );	
		$show_slider 	= isset( $instance['show_slider'] ) ? (bool) $instance['show_slider'] : true;			
	?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Select Category:', 'ecommerce-gigs' ); ?></label>
			<?php
			wp_dropdown_categories(
				array(
					'show_option_none' => '',
					'show_option_all'  => esc_html__('Select','ecommerce-gigs'),
					'name'             => $this->get_field_name( 'category' ),
					'class'			   => 'widefat',	
					'name'             => esc_attr($this->get_field_name( 'category' )),
					'selected'         => absint( $category ), 
				)
			);
			?>
		</p>	

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'product_number' ) ); ?>"><?php esc_html_e( 'Number of Products:', 'ecommerce-gigs' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'product_number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'product_number' ) ); ?>" type="number" value="<?php echo esc_attr( $product_number ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'button' )); ?>"><?php esc_html_e( 'Button Title:', 'ecommerce-gigs' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'button' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'button' ) ); ?>" type="text" value="<?php echo esc_attr( $button ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'button_url' )); ?>"><?php esc_html_e( 'Button Url:', 'ecommerce-gigs' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'button_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'button_url' ) ); ?>" type="text" value="<?php echo esc_url( $button_url ); ?>" />
		</p>	
		<p>
			<input class="checkbox" type="checkbox"<?php checked( $show_slider ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_slider' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_slider' )); ?>" />
	    	<label for="<?php echo esc_attr($this->get_field_id( 'show_slider' )); ?>"><?php echo esc_html__( 'Enable Full Width', 'ecommerce-gigs' ); ?></label>
		</p> 									

	<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'button' ]          	= sanitize_text_field( $new_instance[ 'button' ] );
		$instance[ 'category' ]       	= absint( $new_instance[ 'category' ] );
		$instance[ 'product_number' ] 	= absint( $new_instance[ 'product_number' ] );
		$instance[ 'button_url' ] 		= esc_url_raw( $new_instance[ 'button_url' ] );
		$instance['show_slider'] 	= (bool) $new_instance['show_slider'];
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$category        = isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : '';
		$product_number  = isset( $instance[ 'product_number' ] ) ? $instance[ 'product_number' ] : 3;
		$button = ! empty( $instance['button'] ) ? esc_html($instance['button']) : esc_html__( 'Shop', 'ecommerce-gigs' );
		$button_url = ! empty( $instance['button_url'] ) ? esc_url($instance['button_url']) : '';
		$show_slider		= isset( $instance['show_slider'] ) ? $instance['show_slider'] : true;
		$container_class = 'featured-slider container';
		if ( $show_slider == true ){
			$container_class = 'featured-slider';
		}
		?>
		<section class="<?php echo esc_attr( $container_class );?>">

			<?php $args = array(
				'post_type' => 'post',
				'posts_per_page' => absint( $product_number ),
			);
	        if ( absint( $category ) > 0 ) {
	          $args['cat'] = absint( $category );
	        }			

			$slider_arg = new WP_Query( $args );

			if ( $slider_arg->have_posts() ): ?>
				<div class="owl-carousel owl-theme owl-slider-demo">
					<?php while ( $slider_arg->have_posts() ): $slider_arg->the_post(); 
					$product = wc_get_product( $slider_arg->post->ID ); ?>
						<div class="slider-content">
		                    <div class="slider-content">
		                    	<?php if ( has_post_thumbnail() ): ?>
			                        <figure class="slider-image">
			                        	<?php the_post_thumbnail( 'ecommerce-gigs-main-slider' );?>   
			                        </figure>
		                        <?php endif; ?>
		                        <div class="slider-text">	 
		                        	<div class="entry-content">
		                        		<?php the_excerpt();?>	                        			
	                        		</div>                       	
		                            <h3 class="slider-subtitle"><?php the_title();?></h3>
		                            <?php if ( !empty( $button ) ): ?>
		                           		<a href="<?php echo esc_url( $button_url );?>" class="cart-btn single_add_to_cart_button"><?php echo esc_html( $button );?></a>
	                           		<?php endif; ?>
		                        </div>
		                    </div>							
						</div>
					<?php endwhile; ?>
				</div>	
			<?php endif; 
			wp_reset_postdata(); ?>
		</section>

		<?php 
	}	

}