<?php
/**
 * Display Blog Post
 *
 * @package Ecommerce_Gigs
 */

function ecommerce_gigs_action_blog() {
	register_widget( 'ecommerce_gigs_blog' );	
}
add_action( 'widgets_init', 'ecommerce_gigs_action_blog' );

class ecommerce_gigs_blog extends WP_Widget {
	
	function __construct() {
		
		global $control_ops;

		$widget_ops = array(
			'classname'   => 'latest-blog-section',
			'description' => esc_html__( 'Add Widget to Display Latest Post.', 'ecommerce-gigs' )
		);

		parent::__construct( 'ecommerce_gigs_blog',esc_html__( 'EG: Blog', 'ecommerce-gigs' ), $widget_ops, $control_ops );
	}
	function form( $instance ) {
		$defaults[ 'title' ] = esc_html__( 'Latest', 'ecommerce-gigs' );
		$defaults[ 'category' ]         = '';
		$defaults[ 'number' ]   = 3;
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title           = esc_html( $instance[ 'title' ] );
		$category         = absint( $instance[ 'category' ] );
		$number   = absint( $instance[ 'number' ] );		
	?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( ' Title:', 'ecommerce-gigs' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Select Category:', 'ecommerce-gigs' ); ?></label>
			<?php
			wp_dropdown_categories(
				array(
					'show_option_none' => '',
					'show_option_all'  => esc_html__('Select','ecommerce-gigs'),
					'name'             => $this->get_field_name( 'category' ),
					'class'			   => 'widefat',	
					'name'             => esc_attr($this->get_field_name( 'category' )),
					'selected'         => absint( $category ), 
				)
			);
			?>
		</p>	

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of Products:', 'ecommerce-gigs' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" />
		</p>				
	<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'title' ]          = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'category' ]       = absint( $new_instance[ 'category' ] );
		$instance[ 'number' ] = absint( $new_instance[ 'number' ] );		
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$category        = isset( $instance[ 'category' ] ) ? $instance[ 'category' ] : '';
		$number  = isset( $instance[ 'number' ] ) ? $instance[ 'number' ] : 3;	
		?>
		<section class="latest-blog-section">	
			<div class="container">
				<?php if ( !empty( $title ) ): ?>
	                <header class="entry-header heading default-padding">
	                    <h2 class="entry-title">
	                       <?php echo esc_html( $title );?>
	                    </h2>
	                </header>	
                <?php endif; ?>			
		    	<?php $args = array(
		            'posts_per_page' => absint( $number ),
		            'post_type' => 'post',
		            'post_status' => 'publish',      
		        );

		        if ( absint( $category ) > 0 ) {
		          $args['cat'] = absint( $category );
		        }

				$latest_arg = new WP_Query( $args );

				if ( $latest_arg->have_posts() ): ?>
					<div class="latest-blog-post-wrap flex-display-same-width">
						<?php while ( $latest_arg->have_posts() ): $latest_arg->the_post(); 
						$image_id = get_post_thumbnail_id();
						$image_url = wp_get_attachment_image_src($image_id,'ecommerce-gigs-blog', false);
						?>
							<article class="post">
								<?php if ( has_post_thumbnail() ): ?>
									<div class="featured-image-wrapper">
	                                    <figure class="featured-image">
	                                        <img src="<?php echo esc_url( $image_url[0] ) ?>">
	                                    </figure>	
	                                    <div class="featured-image-icon">
	                                        <a href="<?php the_permalink(); ?>">
	                                            <i class="fa fa-search-plus"></i>
	                                        </a>
	                                    </div> 
	                                </div>  
                                <?php endif; ?>
                                <div class="post-content">
                                    <header class="entry-header">
                                        <h3 class="entry-title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                        </h3>
                                    </header>
                                    <div class="entry-meta">
                                    	<?php ecommerce_gigs_category(); ?>
											<?php ecommerce_gigs_posted_on();?>
                                    </div>
                                    <div class="entry-content">
                                       <?php echo esc_html( wp_trim_words( get_the_content(), 15 ) );?>
                                    </div>
                                    <div class="entry-meta">
										<?php ecommerce_gigs_posted_by(); ?>
                                    </div>
                                </div>								
							</article>
						<?php endwhile; ?>
					</div>	
				<?php endif;
				wp_reset_postdata();  ?> 
			</div>
		</section>	
		<?php 
	}	

}