<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Ecommerce_Gigs
 */

if ( ! function_exists( 'ecommerce_gigs_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function ecommerce_gigs_posted_on() {
		$enable_author = ecommerce_gigs_get_option('enable_author');
		if ( false == $enable_author ){
			return;
		}
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);
		$id = ! empty( $id ) ? $id : get_the_id();
		$year = get_the_date( 'Y', $id );
		$month = get_the_date( 'm', $id );

		// Wrap the time string in a link, and preface it with 'Posted on'.
		printf(
			/* translators: %s: post date */
			__( '<span class="posted-on"><span class="screen-reader-text"></span> %s', 'ecommerce-gigs' ),
			'<a href="' . esc_url( get_month_link( $year, $month ) ) . '" rel="bookmark">' . $time_string . '</a></span>'
		);

	}
endif;

if ( ! function_exists( 'ecommerce_gigs_posted_by' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function ecommerce_gigs_posted_by() {
		$enable_date = ecommerce_gigs_get_option('enable_date');
		if ( false == $enable_date ){
			return;
		}		
		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x( 'by %s', 'post author', 'ecommerce-gigs' ),
			'<figure class="author-image">'.get_avatar( get_the_author_meta( 'ID' ) ).'</figure><span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);

		echo '<span class="byline"> ' . $byline . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	}
endif;

if ( ! function_exists( 'ecommerce_gigs_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function ecommerce_gigs_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'ecommerce-gigs' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'ecommerce-gigs' ) . '</span>', $tags_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'ecommerce-gigs' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				)
			);
			echo '</span>';
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'ecommerce-gigs' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'ecommerce_gigs_category' ) ):
    /**
     *
     */
    function ecommerce_gigs_category(){
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			$categories_list = get_the_category_list( ' ' ); // Separate list by space.

			if ( $categories_list  ) {
				echo '<div class="post-cat-list"><span class="cat-links">' . '<span class="screen-reader-text">' . __( 'Categories', 'ecommerce-gigs' ) . '</span>' . $categories_list . '</span></div>';
			}
		}
    }

endif;


if ( ! function_exists( 'ecommerce_gigs_post_thumbnail' ) ) :
	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function ecommerce_gigs_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
	    	global $post;
	    	$enable_feature_image = get_post_meta( $post->ID, 'enable_feature_image', true );  		
	    	if ( !empty( $enable_feature_image || ! $enable_feature_image == '' ) ){
	    		if ( $enable_feature_image == 'yes' ){ 
			        echo '<div class="post-thumbnail">';
						the_post_thumbnail();
			        echo '</div>';
	    		}
	    	}else { 
		        echo '<div class="post-thumbnail">';
					the_post_thumbnail();
		        echo '</div>';
	    	}
		else : ?>
			<figure class="featured-image">
				<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
					<?php
						the_post_thumbnail(
							'ecommerce-gigs-listing',
							array(
								'alt' => the_title_attribute(
									array(
										'echo' => false,
									)
								),
							)
						);
					?>
				</a>
			</figure>

			<?php
		endif; // End is_singular().
	}
endif;
