<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Ecommerce_Gigs
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function ecommerce_gigs_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
	global $post;
	$sidebar_layout = 'right-sidebar';
	if ( is_page() || is_single() ){
	        $sidebar_layout = get_post_meta( $post->ID, 'sidebar_options', true ); 
	        if ( $sidebar_layout == 'customizer_setting' ){
	        	$sidebar_layout = ecommerce_gigs_get_option( 'sidebar_layout' );
	        }else {
	        	$sidebar_layout = get_post_meta( $post->ID, 'sidebar_options', true ); 
	        }
	} else{
	        $sidebar_layout = ecommerce_gigs_get_option( 'sidebar_layout' );
	}	

	$classes[] = esc_attr( $sidebar_layout );

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'ecommerce_gigs_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function ecommerce_gigs_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'ecommerce_gigs_pingback_header' );

if ( ! function_exists( 'ecommerce_gigs_title' ) ) :
    /**
     * Single Page/Post Title
     *
     * @return Boolean
     */
    function ecommerce_gigs_title() {
    	global $post;
    	$enable_title = get_post_meta( $post->ID, 'enable_title', true );  
    	if ( !empty( $enable_title || ! $enable_title == '' ) ){
    		if ( $enable_title == 'yes' ){ 
		        echo '<header class="entry-header">';
					the_title( '<h4 class="entry-title">', '</h4>' );
		        echo '</header>';
    		}
    	}else { 
	        echo '<header class="entry-header">';
				the_title( '<h4 class="entry-title">', '</h4>' );
	        echo '</header>';
    	}	
    }
endif;

if ( ! function_exists( 'ecommerce_gigs_single_post_meta' ) ) :
    /**
     * Single Page/Post Title
     *
     * @return Boolean
     */
    function ecommerce_gigs_single_post_meta() {
    	global $post;
    	$enable_post_meta = get_post_meta( $post->ID, 'enable_post_meta', true );  
    	if ( !empty( $enable_post_meta || ! $enable_post_meta == '' ) ){
    		if ( $enable_post_meta == 'yes' ){ 
		        echo '<div class="entry-meta">';
	                $enable_single_author = ecommerce_gigs_get_option('enable_single_author');
	                if ( true == $enable_single_author ){
	                    ecommerce_gigs_posted_by();
	                }                 
	                $enable_single_date = ecommerce_gigs_get_option('enable_single_date');
	                if ( true == $enable_single_date ){
	                    ecommerce_gigs_posted_on();
	                } 
		        echo '</div>';
    		}
    	}else { 
	        echo '<div class="entry-meta">';
                $enable_single_author = ecommerce_gigs_get_option('enable_single_author');
                if ( true == $enable_single_author ){
                    ecommerce_gigs_posted_by();
                }                 
                $enable_single_date = ecommerce_gigs_get_option('enable_single_date');
                if ( true == $enable_single_date ){
                    ecommerce_gigs_posted_on();
                } 
	        echo '</div>';
    	}	
    }
endif;
