<?php
/**
 * Base meta box class.
 *
 * @package Ecommerce_Gigs
 */
if ( ! class_exists( 'Ecommerce_Gigs_Meta_Box' ) ) {
	/**
	 * Class Ecommerce_Gigs_Meta_Box
	 */
	class Ecommerce_Gigs_Meta_Box {
		/**
		 * Instance
		 *
		 * @var $instance
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}		

		/**
		 * Hook into the appropriate actions when the class is constructed.
		 */
		public function __construct() {

			if ( is_admin() ) {
				add_action( 'load-post.php',     array( $this, 'init_metabox' ) );
				add_action( 'load-post-new.php', array( $this, 'init_metabox' ) );
			}

		}

		/**
		 * Adds the meta box container.
		 */
		public function init_metabox() {

			add_action( 'add_meta_boxes', array( $this, 'add_metabox'  )        );
			add_action( 'save_post',      array( $this, 'save_metabox' ), 10, 2 );

		}

		public function add_metabox() {
			add_meta_box(
				'ecommerce_gigs_theme_setting',
				esc_html__( 'Theme Setting', 'ecommerce-gigs' ),
				array( $this, 'render_metabox' ),
				array( 'post', 'page'),
				'side',
				'default'
			);

		}

		public function render_metabox( $post ) {

		$meta = get_post_meta( $post->ID );
		$sidebar_options = ( isset( $meta['sidebar_options'][0] ) && '' !== $meta['sidebar_options'][0] ) ? $meta['sidebar_options'][0] : 'customizer_setting';		
		$enable_title = ( isset( $meta['enable_title'][0] ) &&  'no' === $meta['enable_title'][0] ) ? 'no' : 'yes';
		$enable_comment = ( isset( $meta['enable_comment'][0] ) &&  'no' === $meta['enable_comment'][0] ) ? 'no' : 'yes';
		$enable_post_meta = ( isset( $meta['enable_post_meta'][0] ) &&  'no' === $meta['enable_post_meta'][0] ) ? 'no' : 'yes';
		$enable_feature_image = ( isset( $meta['enable_feature_image'][0] ) &&  'no' === $meta['enable_feature_image'][0] ) ? 'no' : 'yes';
		wp_nonce_field( 'ecommerce_gigs_control_meta_box', 'ecommerce_gigs_control_meta_box_nonce' ); // Always add nonce to your meta boxes!
		?>
		<div class="post_meta_extras">
			<p><label><?php esc_html_e( 'Sidebar Option', 'ecommerce-gigs' ); ?></label><br>
				<select id="sidebar_options" name="sidebar_options">
					<option value="<?php echo esc_attr( 'customizer_setting' ); ?>"<?php selected( $sidebar_options, 'customizer_setting', true ); ?>><?php esc_html_e( 'Customizer Setting', 'ecommerce-gigs' ); ?></option>
					<option value="<?php echo esc_attr( 'right_sidebar' ); ?>" <?php selected( $sidebar_options, 'right_sidebar', true ); ?>><?php esc_html_e( 'Right Sidebar', 'ecommerce-gigs' ); ?></option>
					<option value="<?php echo esc_attr( 'left_sidebar' ); ?>" <?php selected( $sidebar_options, 'left_sidebar', true ); ?>><?php esc_html_e( 'Left Sidebar', 'ecommerce-gigs' ); ?></option>
					<option value="<?php echo esc_attr( 'no_sidebar' ); ?>" <?php selected( $sidebar_options, 'no_sidebar', true ); ?>><?php esc_html_e( 'No Sidebar', 'ecommerce-gigs' ); ?></option>
				</select>
			</p>
			<p>
				<label><input type="checkbox" name="enable_title" value="yes" <?php checked( $enable_title, 'yes' ); ?> /><?php esc_html_e( 'Enable Title', 'ecommerce-gigs' ); ?></label>
			</p>
			<p>
				<label><input type="checkbox" name="enable_comment" value="yes" <?php checked( $enable_comment, 'yes' ); ?> /><?php esc_html_e( 'Enable Comment', 'ecommerce-gigs' ); ?></label>
			</p>
			<p>
				<label><input type="checkbox" name="enable_post_meta" value="yes" <?php checked( $enable_post_meta, 'yes' ); ?> /><?php esc_html_e( 'Enable Post Meta', 'ecommerce-gigs' ); ?></label>
			</p>			
			<p>
				<label><input type="checkbox" name="enable_feature_image" value="yes" <?php checked( $enable_feature_image, 'yes' ); ?> /><?php esc_html_e( 'Enable Feature Image', 'ecommerce-gigs' ); ?></label>
			</p>
		</div>							
		<?php			
		}

		public function save_metabox( $post_id, $post ) {

		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times. Add as many nonces, as you
		 * have metaboxes.
		 */
		if ( ! isset( $_POST['ecommerce_gigs_control_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( $_POST['ecommerce_gigs_control_meta_box_nonce'] ), 'ecommerce_gigs_control_meta_box' ) ) { // Input var okay.
			return $post_id;
		}
 
		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) { // Input var okay.
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			}
		} else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}
 
		/*
		 * If this is an autosave, our form has not been submitted,
		 * so we don't want to do anything.
		 */
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}
 
		if ( isset( $_POST['sidebar_options'] ) ) { // Input var okay.
			update_post_meta( $post_id, 'sidebar_options', sanitize_text_field( wp_unslash( $_POST['sidebar_options'] ) ) ); // Input var okay.
		} 
		$enable_title = ( isset( $_POST['enable_title'] ) && 'yes' === $_POST['enable_title'] ) ? 'yes' : 'no'; // Input var okay.
		update_post_meta( $post_id, 'enable_title',  $enable_title );

		$enable_feature_image = ( isset( $_POST['enable_feature_image'] ) && 'yes' === $_POST['enable_feature_image'] ) ? 'yes' : 'no'; // Input var okay.
		update_post_meta( $post_id, 'enable_feature_image',  $enable_feature_image );

		$enable_comment = ( isset( $_POST['enable_comment'] ) && 'yes' === $_POST['enable_comment'] ) ? 'yes' : 'no'; // Input var okay.
		update_post_meta( $post_id, 'enable_comment', $enable_comment  );
		$enable_post_meta = ( isset( $_POST['enable_post_meta'] ) && 'yes' === $_POST['enable_post_meta'] ) ? 'yes' : 'no'; // Input var okay.
		update_post_meta( $post_id, 'enable_post_meta', $enable_post_meta  );				
	    		    

		}

	}
}
/**
 * Kicking this off by calling 'get_instance()' method
 */
Ecommerce_Gigs_Meta_Box::get_instance();