<?php
/**
 * Custom theme functions.
 *
 * This file contains hook functions attached to theme hooks.
 *
 * @package Ecommerce_Gigs
 */
if ( ! function_exists( 'ecommerce_gigs_top_header_right' ) ):
	/**
	 * Top Right Header Section
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_top_header_right() { ?>
        <?php $top_header_right  = ecommerce_gigs_get_option( 'top_header_right' );
            switch ( $top_header_right ) {

                case 'address':
                    $header_address = ecommerce_gigs_get_option('header_address');
                    $header_number = ecommerce_gigs_get_option('header_number');
                    $header_email = ecommerce_gigs_get_option('header_email');?>
                    <div class="top-right">
	                    <div class="contact-info">
	                        <?php if(!empty($header_address)):?>
	                            <div class="contact-address">              
	                                    <span class="icon">
	                                        <i class="fa fa-map-marker" aria-hidden="true"></i>
	                                    </span>
	                                <?php echo esc_html( $header_address );?>
	                            </div>
	                        <?php endif;?>
	                        <?php if(!empty($header_number)):?>
	                            <div class="contact-phone">
	                                <a href="tel:<?php echo esc_attr(preg_replace( '/\D+/', '', esc_attr( $header_number ) ) ); ?>">
	                                    <span class="icon">
	                                        <i class="fa fa-phone" aria-hidden="true"></i>
	                                    </span>
	                                    <?php echo esc_html($header_number);?></a>
	                            </div>
	                        <?php endif;?>

	                        <?php if(!empty($header_email)):?>
	                            <div class="contact-email">
	                                <a href="mailto:<?php echo esc_attr($header_email);?>">
	                                    <span class="icon">
	                                        <i class="fa fa-envelope-o" aria-hidden="true"></i>
	                                    </span>
	                                    <?php echo esc_html( antispambot( $header_email ) ); ?>
	                                </a>
	                            </div>
	                        <?php endif;?>                                  
	                    </div>
                    </div>
                    <?php break;

                case 'menu':
                    ?>               
                	<div class="top-right">
	                    <?php wp_nav_menu( array(
	                        'theme_location'  => 'top-menu',
	                        'container'       => false,                         
	                        'depth'           => 1,
	                        'fallback_cb'     => false,
	                    ) ); ?>
                    </div>
                    <?php break;

                case 'social_media':
                    echo '<div class="top-right"><div class="social-links">';
                        wp_nav_menu( array(
                            'theme_location'  => 'social-media',
                            'container'       => false,                         
                            'depth'           => 1,
                            'fallback_cb'     => false,

                        ) ); 
                    echo '</div></div>';

                    break;
                case 'login_register':
            		if( ! class_exists( 'WooCommerce' ) ) {
						return;
					}?>
					<div class="top-right">
			            <ul>
			            	<?php
			            	if( class_exists( 'WooCommerce' ) ) {
			            		?>
			                    <li>
			                    	<?php
			                    	if( is_user_logged_in() ) {
			                    		?>
			                    		<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>"><i class='bx bx-user'></i> <?php esc_html_e( 'My account', 'ecommerce-gigs' ); ?></a>
			                    		<?php
			                    	} else {
			                    		?>
			                    		<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>"><i class='bx bx-user'></i> <?php esc_html_e( 'Login In/ Register', 'ecommerce-gigs' ); ?></a>
			                    		<?php
			                    	}
			                    	?>
			                    </li>
			                    <?php
			                }
			                ?>
			            </ul>	
		            </div>				
                    <?php break;                    

                case 'none':    
                    break;    

                default:
                    return;

            }
        ?>
	<?php }	
	add_action( 'ecommerce_gigs_action_top_header_right', 'ecommerce_gigs_top_header_right', 10 );
endif;

if ( ! function_exists( 'ecommerce_gigs_top_header_left' ) ):
	/**
	 * Top Left Header Section
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_top_header_left() { ?>
        <?php $top_header_left  = ecommerce_gigs_get_option( 'top_header_left' );
            switch ( $top_header_left ) {

                case 'address':
                    $header_address = ecommerce_gigs_get_option('header_address');
                    $header_number = ecommerce_gigs_get_option('header_number');
                    $header_email = ecommerce_gigs_get_option('header_email');?>
                    <div class="top-left">
	                    <div class="contact-info">
	                        <?php if(!empty($header_address)):?>
	                            <div class="contact-address">              
	                                    <span class="icon">
	                                        <i class="fa fa-map-marker" aria-hidden="true"></i>
	                                    </span>
	                                <?php echo esc_html( $header_address );?>
	                            </div>
	                        <?php endif;?>
	                        <?php if(!empty($header_number)):?>
	                            <div class="contact-phone">
	                                <a href="tel:<?php echo esc_attr(preg_replace( '/\D+/', '', esc_attr( $header_number ) ) ); ?>">
	                                    <span class="icon">
	                                        <i class="fa fa-phone" aria-hidden="true"></i>
	                                    </span>
	                                    <?php echo esc_html($header_number);?></a>
	                            </div>
	                        <?php endif;?>

	                        <?php if(!empty($header_email)):?>
	                            <div class="contact-email">
	                                <a href="mailto:<?php echo esc_attr($header_email);?>">
	                                    <span class="icon">
	                                        <i class="fa fa-envelope-o" aria-hidden="true"></i>
	                                    </span>
	                                    <?php echo esc_html( antispambot( $header_email ) ); ?>
	                                </a>
	                            </div>
	                        <?php endif;?>                                  
	                    </div>
                    </div>
                    <?php break;

                case 'menu':
                    ?>               
                	<div class="top-left">
	                    <?php wp_nav_menu( array(
	                        'theme_location'  => 'top-menu',
	                        'container'       => false,                         
	                        'depth'           => 1,
	                        'fallback_cb'     => false,
	                    ) ); ?>
                    </div>
                    <?php break;

                case 'social_media':
                    echo '<div class="top-left"><div class="social-links">';
                        wp_nav_menu( array(
                            'theme_location'  => 'social-media',
                            'container'       => false,                         
                            'depth'           => 1,
                            'fallback_cb'     => false,

                        ) ); 
                    echo '</div></div>';

                    break;
                case 'login_register':
            		if( ! class_exists( 'WooCommerce' ) ) {
						return;
					}?>
					<div class="top-left">
			            <ul>
			            	<?php
			            	if( class_exists( 'WooCommerce' ) ) {
			            		?>
			                    <li>
			                    	<?php
			                    	if( is_user_logged_in() ) {
			                    		?>
			                    		<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>"><i class='bx bx-user'></i> <?php esc_html_e( 'My account', 'ecommerce-gigs' ); ?></a>
			                    		<?php
			                    	} else {
			                    		?>
			                    		<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>"><i class='bx bx-user'></i> <?php esc_html_e( 'Login In/ Register', 'ecommerce-gigs' ); ?></a>
			                    		<?php
			                    	}
			                    	?>
			                    </li>
			                    <?php
			                }
			                ?>
			            </ul>	
		            </div>				
                    <?php break;                    

                case 'none':    
                    break;    

                default:
                    return;

            }
        ?>
	<?php }	
	add_action( 'ecommerce_gigs_action_top_header_left', 'ecommerce_gigs_top_header_left', 10 );
endif;
if ( ! function_exists( 'ecommerce_gigs_vertical_menu' ) ):
	/**
	 * Vertical Menu Section
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_vertical_menu() { ?>
		<?php $enable_vertical_menu  = ecommerce_gigs_get_option( 'enable_vertical_menu' );
		$vertical_menu_title  = ecommerce_gigs_get_option( 'vertical_menu_title' );
		if ( false == $enable_vertical_menu ):
			return;
		endif;?>
        <div class="category-info">
        	<?php if( !empty( $vertical_menu_title ) ): ?>
            	<a href="JavaScript:void(0)"><i class="fa fa-bars"></i><?php echo esc_html( $vertical_menu_title );?></a>
        	<?php endif; ?>
            <div class="category-listing">
				<?php 
					wp_nav_menu( array(
	                    'theme_location'  => 'vertical-menu',
	                    'container'       => false,                         
	                    'depth'           => 1,
	                    'fallback_cb'     => false,

	                ) ); 
				?>
            </div>
        </div>
	<?php }	
	add_action( 'ecommerce_gigs_action_vertical_menu', 'ecommerce_gigs_vertical_menu', 10 );
endif;

if ( ! function_exists( 'ecommerce_gigs_beside_menu' ) ):
	/**
	 * Beside Menu 
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_beside_menu() { ?>
        <?php $beside_menu  = ecommerce_gigs_get_option( 'beside_menu' );
            switch ( $beside_menu ) {

                case 'address':
                    $beside_menu_icon = ecommerce_gigs_get_option('beside_menu_icon');
                    $beside_menu_text = ecommerce_gigs_get_option('beside_menu_text');
                    $beside_menu_number = ecommerce_gigs_get_option('beside_menu_number');
                    if ( !empty( $beside_menu_text) || !empty( $beside_menu_number ) ):?>
		                <div class="customer-care">

		                    <a href="JavaScript:void(0)">
		                    	<i class="fa <?php echo esc_attr( $beside_menu_icon );?>" aria-hidden="true"></i>
		                       <?php echo esc_html( $beside_menu_number );?> <span><?php echo esc_html( $beside_menu_text);?></span>
		                    </a>
		                </div>                    
		            <?php endif; ?>
                    <?php break;

                case 'menu':
                    ?>               
            	
                    <?php wp_nav_menu( array(
                        'theme_location'  => 'beside-menu',
                        'container'       => false,                         
                        'depth'           => 1,
                        'fallback_cb'     => false,
                    ) ); ?>
                
                    <?php break;

                case 'social_media':
                    echo '<div class="social-links">';
                        wp_nav_menu( array(
                            'theme_location'  => 'social-media',
                            'container'       => false,                         
                            'depth'           => 1,
                            'fallback_cb'     => false,

                        ) ); 
                    echo '</div>';

                    break;
                case 'button':
            		$beside_menu_icon = ecommerce_gigs_get_option('beside_menu_icon');
                    $beside_menu_text = ecommerce_gigs_get_option('beside_menu_text');
                    $beside_menu_text_url = ecommerce_gigs_get_option('beside_menu_text_url');
                    ?>
	                <div class="beside-menu-button">

	                    <a href="<?php echo esc_url( $beside_menu_text_url );?>">
	                    	<i class="fa <?php echo esc_attr( $beside_menu_icon );?>" aria-hidden="true"></i>
	                       <?php echo esc_html( $beside_menu_text);?>
	                    </a>
	                </div>									
                    <?php break;                    

                case 'none':    
                    break;    

                default:
                    return;

            }
        ?>
	<?php }	
	add_action( 'ecommerce_gigs_action_beside_menu', 'ecommerce_gigs_beside_menu', 10 );
endif;

if ( ! function_exists( 'ecommerce_gigs_header_search' ) ):
	/**
	 * Bottom Header Search
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_header_search() { 
		$enable_header_search = ecommerce_gigs_get_option('enable_header_search');
		if ( false == $enable_header_search ){
			return;
		}?>
        <div class="header-search-section">
        	<div class="search-toggle">
                <a href="JavaScript:void(0)"><i class="fa fa-search"></i></a>
            </div>
        	<?php if ( class_exists( 'WooCommerce' ) ) { 
        		get_product_search_form();
    		} else{
    			get_search_form();
			} ?>
        </div>
	<?php }	
	add_action( 'ecommerce_gigs_action_header_search', 'ecommerce_gigs_header_search', 10 );
endif;

if ( ! function_exists( 'ecommerce_gigs_header_cart' ) ):
	/**
	 * Bottom Header Woocommerce Cart
	 * 
	 * @since 1.0.0
	 */
	function ecommerce_gigs_header_cart() { ?>

        <div class="header-information-inner">
        	<?php $enable_header_cart = ecommerce_gigs_get_option('enable_header_cart');
        	$header_cart_text = ecommerce_gigs_get_option('header_cart_text');
        	if ( class_exists( 'WooCommerce' ) && true == $enable_header_cart ) : ?>
				<div class="site-cart-views woocommerce">
					<div class="site-cart-info">
						<a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
							<i class="fa fa-shopping-cart" aria-hidden="true"></i>
							<span class="cart-quantity"><?php echo wp_kses_data( WC()->cart->get_cart_contents_count() );?></span><?php echo esc_html( $header_cart_text);?>
						</a>
					</div>	
					<div class="widget widget_shopping_cart">	
						<div class="mini_cart_inner">					
                        <?php $instance = array( 'title' => '' );
                        	woocommerce_mini_cart( $instance );
                        ?>
						</div>						
					</div>
				</div>   
			<?php endif; ?> 
	        <?php $enable_header_wishlist = ecommerce_gigs_get_option('enable_header_wishlist');
	        $header_wishlist_text = ecommerce_gigs_get_option('header_wishlist_text');
	        if ( class_exists( 'YITH_WCWL' ) && true == $enable_header_wishlist ) : 
	        	$ecommerce_gigs_page_id =  get_option( 'yith_wcwl_wishlist_page_id' );
				$ecommerce_gigs_page_wishlist_permalink = get_the_permalink( $ecommerce_gigs_page_id );?>
	            <div class="site-wishlist-views">
	                <div class="site-wish-info">
	                	<a href="<?php echo esc_url( $ecommerce_gigs_page_wishlist_permalink );?>">
		                    <i class="fa fa-heart-o" aria-hidden="true"></i>
		                    <?php echo esc_html( $header_wishlist_text);?>
	                    </a>
	                </div>
	            </div>	          
	        <?php endif; ?>
        </div>
	<?php }	
	add_action( 'ecommerce_gigs_action_header_cart', 'ecommerce_gigs_header_cart', 10 );
endif;
