<?php
/**
 * Theme Customizer Options
 *
 * @package Ecommerce_Gigs
 */
$default = ecommerce_gigs_get_default_theme_options();

// Add Panel
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => esc_html__( 'Theme Options', 'ecommerce-gigs' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	)
);
$wp_customize->add_setting('theme_options[logo_width]', 
	array(
	'default' 			=> $default['logo_width'],
	'priority'   		=> 10,
	'sanitize_callback' => 'ecommerce_gigs_sanitize_number_range'
	)
);
$wp_customize->add_control( new Ecommerce_Gigs_Slider_Control( $wp_customize,'theme_options[logo_width]',array(	
	'label' 	=> esc_html__('Logo Width', 'ecommerce-gigs'),
	'section' 	=> 'title_tagline',
	'settings'  => 'theme_options[logo_width]',
	'type' 		=> 'slider_control',
	'input_attrs' => array(
		'min' => 0, 
		'max' => 100, 
		'step' => 1, 
	),
) ) );
// Top Header Section
$wp_customize->add_section('section_top_header', 
	array(    
	'title'       => esc_html__('Top Header Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);

// Enable Top Header
$wp_customize->add_setting( 'theme_options[enable_top_header]',
    array(
        'default'           => $default['enable_top_header'],
      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_top_header]',
    array(
        'label'    => esc_html__( 'Enable Top Header', 'ecommerce-gigs' ),
        'section'  => 'section_top_header',
        'type'     => 'checkbox',     
    )
);
// Top Header Right Options
$wp_customize->add_setting('theme_options[top_header_right]', 
	array(
	'default' 			=> $default['top_header_right'],
	'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
	)
);
if ( class_exists( 'WooCommerce' ) ) {
	$wp_customize->add_control('theme_options[top_header_right]', 
		array(		
		'label' 	=> esc_html__('Top Right Header Option', 'ecommerce-gigs'),
		'section' 	=> 'section_top_header',
		'settings'  => 'theme_options[top_header_right]',
		'type' 		=> 'select',
	    'active_callback'    => 'ecommerce_gigs_callback_top_header',  	
		'choices' 	=>  array(
				'none' 		    => esc_html__('&mdash; Select &mdash;', 'ecommerce-gigs'),
				'menu' 			=> esc_html__('Menu', 'ecommerce-gigs'),
				'address' 		=> esc_html__('Address', 'ecommerce-gigs'),
				'social_media' 	=> esc_html__('Social Icon', 'ecommerce-gigs'),
				'login_register' 	=> esc_html__('Login/Register Link', 'ecommerce-gigs'),
			)
		)
	);
} else{
	$wp_customize->add_control('theme_options[top_header_right]', 
		array(		
		'label' 	=> esc_html__('Top Right Header Option', 'ecommerce-gigs'),
		'section' 	=> 'section_top_header',
		'settings'  => 'theme_options[top_header_right]',
		'type' 		=> 'select',
	    'active_callback'    => 'ecommerce_gigs_callback_top_header',  	
		'choices' 	=>  array(
				'none' 		    => esc_html__('&mdash; Select &mdash;', 'ecommerce-gigs'),
				'menu' 			=> esc_html__('Menu', 'ecommerce-gigs'),
				'address' 		=> esc_html__('Address', 'ecommerce-gigs'),
				'social_media' 	=> esc_html__('Social Icon', 'ecommerce-gigs'),
			)
		)
	);	
}

if ( class_exists( 'WooCommerce' ) ) {
	// Top Header Left Options
	$wp_customize->add_setting('theme_options[top_header_left]', 
		array(
		'default' 			=> $default['top_header_left'],
		'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
		)
	);

	$wp_customize->add_control('theme_options[top_header_left]', 
		array(		
		'label' 	=> esc_html__('Top Left Header Option', 'ecommerce-gigs'),
		'section' 	=> 'section_top_header',
		'settings'  => 'theme_options[top_header_left]',
		'type' 		=> 'select',
		'active_callback'    => 'ecommerce_gigs_callback_top_header', 
		'choices' 	=>  array(
				'none' 			=> esc_html__('&mdash; Select &mdash;', 'ecommerce-gigs'),
				'menu' 			=> esc_html__('Menu', 'ecommerce-gigs'),
				'address' 		=> esc_html__('Address', 'ecommerce-gigs'),
				'social_media' 	=> esc_html__('Social Icon', 'ecommerce-gigs'),
				'login_register' => esc_html__('Login/Register Link', 'ecommerce-gigs'),
			)
		)
	);
} else{
	// Top Header Left Options
	$wp_customize->add_setting('theme_options[top_header_left]', 
		array(
		'default' 			=> $default['top_header_left'],
		'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
		)
	);

	$wp_customize->add_control('theme_options[top_header_left]', 
		array(		
		'label' 	=> esc_html__('Top Left Header Option', 'ecommerce-gigs'),
		'section' 	=> 'section_top_header',
		'settings'  => 'theme_options[top_header_left]',
		'type' 		=> 'select',
		'active_callback'    => 'ecommerce_gigs_callback_top_header', 
		'choices' 	=>  array(
				'none' 		=> esc_html__('&mdash; Select &mdash;', 'ecommerce-gigs'),
				'menu' 			=> esc_html__('Menu', 'ecommerce-gigs'),
				'address' 		=> esc_html__('Address', 'ecommerce-gigs'),
				'social_media' 	=> esc_html__('Social Icon', 'ecommerce-gigs'),
			)
		)
	);	
}

/************************  Header Address  ******************/
$wp_customize->add_setting( 'theme_options[header_address]',
	array(
	'default'           => $default['header_address'],
	'sanitize_callback' => 'sanitize_textarea_field',	
	)
);
$wp_customize->add_control( 'theme_options[header_address]',
	array(
	'label'    => esc_html__( 'Header Address', 'ecommerce-gigs' ),
	'section'  => 'section_top_header',
	'type'     => 'text',
	'active_callback'    => 'ecommerce_gigs_header_address', 
	
	)
);

/************************  Top Header Phone Number  ******************/
$wp_customize->add_setting( 'theme_options[header_number]',
	array(
	'default'           => $default['header_number'],
	'sanitize_callback' => 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[header_number]',
	array(
	'label'    => esc_html__( 'Phone Number', 'ecommerce-gigs' ),
	'section'  => 'section_top_header',
	'type'     => 'text',
	'active_callback'    => 'ecommerce_gigs_header_address', 
	
	)
);

/************************  Top Header Email  ******************/
$wp_customize->add_setting('theme_options[header_email]',  
	array(
	'default'           => $default['header_email'],	
	'sanitize_callback' => 'sanitize_email',
	
	)
);

$wp_customize->add_control('theme_options[header_email]', 
	array(
	'label'       => esc_html__('Contact Email', 'ecommerce-gigs'),
	'section'     => 'section_top_header',   
	'settings'    => 'theme_options[header_email]',		
	'type'        => 'text',
	'active_callback'    => 'ecommerce_gigs_header_address', 
	)
);
// Beside Header Section
$wp_customize->add_section('section_beside_header', 
	array(    
	'title'       => esc_html__('Beside Menu Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);
// Top Header Left Options
$wp_customize->add_setting('theme_options[beside_menu]', 
	array(
	'default' 			=> $default['beside_menu'],
	'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[beside_menu]', 
	array(		
	'label' 	=> esc_html__('Beside Menu Option', 'ecommerce-gigs'),
	'section' 	=> 'section_beside_header',
	'settings'  => 'theme_options[beside_menu]',
	'type' 		=> 'select',
	'choices' 	=>  array(
			'none' 		=> esc_html__('&mdash; Select &mdash;', 'ecommerce-gigs'),
			'menu' 			=> esc_html__('Menu', 'ecommerce-gigs'),
			'address' 		=> esc_html__('Phone Number', 'ecommerce-gigs'),
			'social_media' 	=> esc_html__('Social Icon', 'ecommerce-gigs'),
			'button' 	=> esc_html__('Button', 'ecommerce-gigs'),
		)
	)
);
// Beside Menu Icon
$wp_customize->add_setting('theme_options[beside_menu_icon]', 
	array(
	'default' 			=> $default['beside_menu_icon'],
	'priority'   		=> 10,
	'sanitize_callback' => 'sanitize_key'
	)
);
$wp_customize->add_control( new Ecommerce_Gigs_Icons_Control( $wp_customize,'theme_options[beside_menu_icon]',array(	
	'label' 	=> esc_html__('Icon', 'ecommerce-gigs'),
	'section' 	=> 'section_beside_header',
	'settings'  => 'theme_options[beside_menu_icon]',
	'active_callback'    => 'ecommerce_gigs_callback_beside_menu_address_button', 	
	'type' 		=> 'ecommerce_gigs_icon',
	) 
) );
// Beside Menu Number
$wp_customize->add_setting('theme_options[beside_menu_number]', 
	array(
	'default'           => $default['beside_menu_number'],	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[beside_menu_number]', 
	array(
	'label'       => esc_html__('Beside Phone Number', 'ecommerce-gigs'),
	'section'     => 'section_beside_header',   
	'settings'    => 'theme_options[beside_menu_number]',
	'active_callback'    => 'ecommerce_gigs_callback_beside_menu_address', 		
	'type'        => 'text',
	)
);
// Beside Menu Text
$wp_customize->add_setting('theme_options[beside_menu_text]', 
	array(
	'default'           => $default['beside_menu_text'],	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[beside_menu_text]', 
	array(
	'label'       => esc_html__('Beside Button Text', 'ecommerce-gigs'),
	'section'     => 'section_beside_header',   
	'settings'    => 'theme_options[beside_menu_text]',
	'active_callback'    => 'ecommerce_gigs_callback_beside_menu_address_button', 		
	'type'        => 'text',

	)
);
// Beside Menu Text Url
$wp_customize->add_setting('theme_options[beside_menu_text_url]', 
    array(
    'default'           => $default['beside_menu_text_url'],
  
      
    'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control('theme_options[beside_menu_text_url]', 
    array(
    'label'       => esc_html__('Beside Button Text Url', 'ecommerce-gigs'),
    'section'     => 'section_beside_header',   
    'settings'    => 'theme_options[beside_menu_text_url]', 
    'active_callback' => 'ecommerce_gigs_callback_beside_menu_button',       
    'type'        => 'text', 
    )
);

// Bottom Header Section
$wp_customize->add_section('section_bottom_header', 
	array(    
	'title'       => esc_html__('Bottom Header Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);
// Enable Vertical Menu
$wp_customize->add_setting( 'theme_options[enable_vertical_menu]',
    array(
        'default'           => $default['enable_vertical_menu'],
      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_vertical_menu]',
    array(
        'label'    => esc_html__( 'Enable Vertical Menu', 'ecommerce-gigs' ),
        'section'  => 'section_bottom_header',
        'type'     => 'checkbox',     
    )
);
// Vertical Menu Title
$wp_customize->add_setting('theme_options[vertical_menu_title]', 
	array(
	'default'           => $default['vertical_menu_title'],	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[vertical_menu_title]', 
	array(
	'label'       => esc_html__('Vertical Menu Title', 'ecommerce-gigs'),
	'section'     => 'section_bottom_header',   
	'settings'    => 'theme_options[vertical_menu_title]',		
	'type'        => 'text',
	'active_callback'    => 'ecommerce_gigs_callback_header_vertical_menu', 

	)
);
// Enable Search Section
$wp_customize->add_setting( 'theme_options[enable_header_search]',
    array(
        'default'           => $default['enable_header_search'],
      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_header_search]',
    array(
        'label'    => esc_html__( 'Enable Header Search', 'ecommerce-gigs' ),
        'section'  => 'section_bottom_header',
        'type'     => 'checkbox',     
    )
);
if ( class_exists( 'WooCommerce' ) ):
	// Enable Cart List
	$wp_customize->add_setting( 'theme_options[enable_header_cart]',
	    array(
	        'default'           => $default['enable_header_cart'],
	      
	        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
	    )
	);
	$wp_customize->add_control( 'theme_options[enable_header_cart]',
	    array(
	        'label'    => esc_html__( 'Enable Header Cart', 'ecommerce-gigs' ),
	        'section'  => 'section_bottom_header',
	        'type'     => 'checkbox',     
	    )
	);
	// Header Cart Text
	$wp_customize->add_setting('theme_options[header_cart_text]', 
		array(
		'default'           => $default['header_cart_text'],
	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control('theme_options[header_cart_text]', 
		array(
		'label'       => esc_html__('Header Cart Text', 'ecommerce-gigs'),
		'section'     => 'section_bottom_header',   
		'settings'    => 'theme_options[header_cart_text]',
		'active_callback'    => 'ecommerce_gigs_callback_header_cart', 		
		'type'        => 'text',
		)
	);
endif;
if ( class_exists( 'YITH_WCWL' ) ):
	// Enable Wishlist List
	$wp_customize->add_setting( 'theme_options[enable_header_wishlist]',
	    array(
	        'default'           => $default['enable_header_wishlist'],
	      
	        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
	    )
	);
	$wp_customize->add_control( 'theme_options[enable_header_wishlist]',
	    array(
	        'label'    => esc_html__( 'Enable Header Wishlist', 'ecommerce-gigs' ),
	        'section'  => 'section_bottom_header',
	        'type'     => 'checkbox',     
	    )
	);
	// Header Wishlist Text
	$wp_customize->add_setting('theme_options[header_wishlist_text]', 
		array(
		'default'           => $default['header_wishlist_text'],
	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control('theme_options[header_wishlist_text]', 
		array(
		'label'       => esc_html__('Header Wishlist Text', 'ecommerce-gigs'),
		'section'     => 'section_bottom_header',   
		'settings'    => 'theme_options[header_wishlist_text]',
		'active_callback'    => 'ecommerce_gigs_callback_header_wishlist', 		
		'type'        => 'text',
		)
	);
endif;

//Layout Section
$wp_customize->add_section('section_layout', 
	array(    
	'title'       => esc_html__('Layout Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);

// Sidebar Layout
$wp_customize->add_setting('theme_options[sidebar_layout]', 
	array(
	'default' 			=> $default['sidebar_layout'],
	'type'              => 'theme_mod',
	'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[sidebar_layout]', 
	array(		
	'label' 	=> esc_html__('Sidebar Layout Options', 'ecommerce-gigs'),
	'section' 	=> 'section_layout',
	'settings'  => 'theme_options[sidebar_layout]',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'right_sidebar' 	=> esc_html__('Right Sidebar', 'ecommerce-gigs'),							
		'left_sidebar' 		=> esc_html__('Left Sidebar', 'ecommerce-gigs'),
		'no_sidebar' 		=> esc_html__('No Sidebar', 'ecommerce-gigs'),		
		),	
	)
);
if ( class_exists( 'WooCommerce' ) ):
	// Sidebar Layout
	$wp_customize->add_setting('theme_options[woo_sidebar_layout]', 
		array(
		'default' 			=> $default['woo_sidebar_layout'],
		'type'              => 'theme_mod',
		'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
		)
	);

	$wp_customize->add_control('theme_options[woo_sidebar_layout]', 
		array(		
		'label' 	=> esc_html__('Woocommerce Sidebar Layout Options', 'ecommerce-gigs'),
		'section' 	=> 'section_layout',
		'settings'  => 'theme_options[woo_sidebar_layout]',
		'type' 		=> 'radio',
		'choices' 	=> array(		
			'right_sidebar' 	=> esc_html__('Right Sidebar', 'ecommerce-gigs'),							
			'left_sidebar' 		=> esc_html__('Left Sidebar', 'ecommerce-gigs'),
			'no_sidebar' 		=> esc_html__('No Sidebar', 'ecommerce-gigs'),		
			),	
		)
	);
endif;
// Listing Page Read More Title
$wp_customize->add_setting( 'theme_options[archive_button_title]',
	array(
	'default'           => $default['archive_button_title'],
	'sanitize_callback' => 'sanitize_text_field',	
	)
);
$wp_customize->add_control( 'theme_options[archive_button_title]',
	array(
	'label'    => esc_html__( 'Archive Read More Title', 'ecommerce-gigs' ),
	'section'  => 'section_layout',
	'type'     => 'text',
	)
);
//General Section
$wp_customize->add_section('section_general', 
	array(    
	'title'       => esc_html__('General Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);
// Enable Author
$wp_customize->add_setting( 'theme_options[enable_author]',
    array(
        'default'           => $default['enable_author'],      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_author]',
    array(
        'label'    => esc_html__( 'Enable Date Post Meta', 'ecommerce-gigs' ),
        'section'  => 'section_general',
        'type'     => 'checkbox',     
    )
);

// Enable Date
$wp_customize->add_setting( 'theme_options[enable_date]',
    array(
        'default'           => $default['enable_date'],      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_date]',
    array(
        'label'    => esc_html__( 'Enable Author Post Meta', 'ecommerce-gigs' ),
        'section'  => 'section_general',
        'type'     => 'checkbox',     
    )
);
//Single Page/Post Section
$wp_customize->add_section('section_single_page', 
	array(    
	'title'       => esc_html__('Single Page/Post Section', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);
// Enable Author in Singe Page/Posts 
$wp_customize->add_setting( 'theme_options[enable_single_author]',
    array(
        'default'           => $default['enable_single_author'],      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_single_author]',
    array(
        'label'    => esc_html__( 'Enable Author Post Meta', 'ecommerce-gigs' ),
        'section'  => 'section_single_page',
        'type'     => 'checkbox',     
    )
);
// Enable Date Singe Page/Posts
$wp_customize->add_setting( 'theme_options[enable_single_date]',
    array(
        'default'           => $default['enable_single_date'],      
        'sanitize_callback' => 'ecommerce_gigs_sanitize_checkbox',        
    )
);
$wp_customize->add_control( 'theme_options[enable_single_date]',
    array(
        'label'    => esc_html__( 'Enable Date Post Meta', 'ecommerce-gigs' ),
        'section'  => 'section_single_page',
        'type'     => 'checkbox',     
    )
);

// Footer Section
$wp_customize->add_section('section_footer', 
	array(    
	'title'       => esc_html__('Footer Setting', 'ecommerce-gigs'),
	'panel'       => 'theme_option_panel'    
	)
);
	$wp_customize->add_setting('theme_options[footer_text_algin]', 
		array(
		'default' 			=> $default['footer_text_algin'],
		'type'              => 'theme_mod',
		'sanitize_callback' => 'ecommerce_gigs_sanitize_select'
		)
	);

	$wp_customize->add_control('theme_options[footer_text_algin]', 
		array(		
		'label' 	=> esc_html__('Footer Widget Text Align', 'ecommerce-gigs'),
		'section' 	=> 'section_footer',
		'settings'  => 'theme_options[footer_text_algin]',
		'type' 		=> 'select',
		'choices' 	=> array(		
			'left' 	=> esc_html__('Left Align', 'ecommerce-gigs'),							
			'center' 		=> esc_html__('Center Align', 'ecommerce-gigs'),
			'right' 		=> esc_html__('Right Align', 'ecommerce-gigs'),		
			),	
		)
	);
