<?php
/**
 * Default theme options.
 *
 * @package Ecommerce_Gigs
 */
if ( ! function_exists( 'ecommerce_gigs_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function ecommerce_gigs_get_default_theme_options() {

		$defaults = array();
		$defaults['enable_top_header']			= false;
		$defaults['logo_width']					= 100;
		$defaults['top_header_right']			= 'none';
		$defaults['top_header_left']			= 'none';
		$defaults['header_address']				= '';
		$defaults['header_email']				= '';
		$defaults['header_number']				= '';
		$defaults['enable_vertical_menu']		= false;
		$defaults['vertical_menu_title']		= '';
		$defaults['enable_header_cart']			= false;
		$defaults['enable_header_wishlist']		= false;
		$defaults['beside_menu']				= 'none';
		$defaults['beside_menu_icon']			= 'fa-phone';
		$defaults['enable_header_search']		= false;
		$defaults['beside_menu_number']			= '';
		$defaults['beside_menu_text']			= '';
		$defaults['beside_menu_text_url']		= '';
		$defaults['header_cart_text']			= '';
		$defaults['header_wishlist_text']		= '';
		$defaults['sidebar_layout']				= 'right_sidebar';
		$defaults['woo_sidebar_layout']			= 'right_sidebar';
		$defaults['archive_button_title']		= '';
		$defaults['enable_header_cart']			= true;
		$defaults['enable_header_wishlist']		= true;	
		$defaults['enable_single_author']		= true;
		$defaults['enable_single_date']			= true;	
		$defaults['enable_author']				= true;
		$defaults['enable_date']				= true;		
		$defaults['footer_text_algin']			= 'left';						

		// Pass through filter.
		$defaults = apply_filters( 'ecommerce_gigs_filter_default_theme_options', $defaults );

		return $defaults;
	}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'ecommerce_gigs_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function ecommerce_gigs_get_option( $key ) {

		$default_options = ecommerce_gigs_get_default_theme_options();

		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;