<?php
/**
 * Customizer custom controls
 *
 * @package Ecommerce_Gigs
 */
/**
 * Slider custom control
 *
 */
class Ecommerce_Gigs_Icons_Control extends WP_Customize_Control {
	/**
	 * Control type
	 *
	 * @var string
	 */
	public $type = 'ecommerce_gigs_icon';
	/**
	 * Control scripts and styles enqueue
	 *
	 * @since 1.0.0
	 */
	public function enqueue() {
		wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/assets/css/font-awesome.min.css', array(), '4.7.0' );
		wp_enqueue_script( 'ecommerce-gigs-custom-controls-js', get_template_directory_uri() . '/inc/customizer/js/icon-controls.js',array( 'jquery', 'jquery-ui-core' ), '1.0.0', true );
		wp_enqueue_style( 'ecommerce-gigs-custom-controls_css', get_template_directory_uri() . '/inc/customizer/css/icon-controls.css' );
	}
	/**
	 * Control method
	 *
	 * @since 1.0.0
	 */
	public function render_content() {
		$saved_icon_value = $this->value();
		echo "<pre>";
			print_r( $saved_icon_value );
		echo "</pre>";
	?>
		<label>
		    <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		    <span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		    <div class="fa-icons-list">
		        <div class="selected-icon-preview"><?php if( !empty( $saved_icon_value ) ) { echo '<i class="fa '. esc_attr($saved_icon_value) .'"></i>'; } ?></div>
		        <ul class="icons-list-wrapper">
		            <?php $icons_list = ecommerce_gigs_all_icons_array();
		            foreach ( $icons_list as $key => $icon_value ) {
		                if( $saved_icon_value == $icon_value ) {
		                    echo '<li class="selected"><i class="fa '. esc_attr($icon_value) .'"></i></li>';
		                } else {
		                    echo '<li><i class="fa '. esc_attr($icon_value) .'"></i></li>';
		                }
		            }
		            ?>
		        </ul>
		        <input type="hidden" class="ap-icon-value" value="" <?php $this->link(); ?>>
		    </div>

		</label>
	<?php
	}
}

/**
 * Slider custom control
 *
 */
class Ecommerce_Gigs_Slider_Control extends WP_Customize_Control {
	/**
	 * Control type
	 *
	 * @var string
	 */
	public $type = 'slider_control';
	/**
	 * Control scripts and styles enqueue
	 *
	 * @since 1.0.0
	 */
	public function enqueue() {
		wp_enqueue_script( 'ecommerce-gigs-slider-controls-js', get_template_directory_uri() . '/inc/customizer/js/icon-controls.js',array( 'jquery', 'jquery-ui-core' ), '1.0.0', true );
		wp_enqueue_style( 'ecommerce-gigs-slider-controls_css', get_template_directory_uri() . '/inc/customizer/css/icon-controls.css' );
	}
	/**
	 * Control method
	 *
	 * @since 1.0.0
	 */
	public function render_content() {
	?>
		<div class="slider-custom-control">
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span><input type="number" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $this->value() ); ?>" class="customize-control-slider-value" <?php $this->link(); ?> />
			<div class="slider" slider-min-value="<?php echo esc_attr( $this->input_attrs['min'] ); ?>" slider-max-value="<?php echo esc_attr( $this->input_attrs['max'] ); ?>" slider-step-value="<?php echo esc_attr( $this->input_attrs['step'] ); ?>"></div><span class="slider-reset dashicons dashicons-image-rotate" slider-reset-value="<?php echo esc_attr( $this->value() ); ?>"></span>
		</div>
	<?php
	}
}