<?php
/**
 * Ecommerce Gigs Theme Customizer
 *
 * @package Ecommerce_Gigs
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ecommerce_gigs_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	// Customizer Control
	require trailingslashit( get_template_directory() ) . '/inc/customizer/control.php';	

	// Load Customize Sanitize.
	require trailingslashit( get_template_directory() ) . '/inc/customizer/sanitize.php';


	// Load Callback option.
	require  trailingslashit( get_template_directory() ) . '/inc/customizer/callback.php';	
	

	// Load Theme Option.
	require trailingslashit( get_template_directory() ) . '/inc/customizer/theme-section.php';	



	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'ecommerce_gigs_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'ecommerce_gigs_customize_partial_blogdescription',
			)
		);
	}

}
add_action( 'customize_register', 'ecommerce_gigs_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function ecommerce_gigs_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function ecommerce_gigs_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ecommerce_gigs_customize_preview_js() {
	wp_enqueue_script( 'ecommerce-gigs-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), ECOMMERCE_GIGS_VERSION, true );
}
add_action( 'customize_preview_init', 'ecommerce_gigs_customize_preview_js' );
