<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Ecommerce_Gigs
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php if ( function_exists( 'wp_body_open' ) ) { 
	wp_body_open(); 
} else{
	do_action( 'wp_body_open' );
}?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'ecommerce-gigs' ); ?></a>
	<?php $ecommerce_gigs_header_image = get_header_image();?>
	<header id="masthead" class="site-header" style="background-image: url(<?php echo esc_url( $ecommerce_gigs_header_image );?>)">
        <!-- header starting from here -->
        <?php ecommerce_gigs_top_header();?>
        <?php ecommerce_gigs_site_branding();?>
        <?php ecommerce_gigs_bottom_header();?>
        <?php ecommerce_gigs_featured_slider();?>	
	</header><!-- #masthead -->
	
	<div id="content" class="site-content">