<?php
/**
 * Ecommerce Gigs functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Ecommerce_Gigs
 */

if ( ! defined( 'ECOMMERCE_GIGS_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'ECOMMERCE_GIGS_VERSION', '1.0.1' );	
}

if ( ! function_exists( 'ecommerce_gigs_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ecommerce_gigs_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Ecommerce Gigs, use a find and replace
		 * to change 'ecommerce-gigs' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'ecommerce-gigs', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		add_image_size( 'ecommerce-gigs-main-slider', 1349, 463, true);
		add_image_size( 'ecommerce-gigs-woocommerce-product', 237, 237, true);
		add_image_size( 'ecommerce-gigs-hot-deal', 510, 262, true);
		add_image_size( 'ecommerce-gigs-blog', 264, 171, true);
		add_image_size( 'ecommerce-gigs-listing', 243, 243, true);

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'ecommerce-gigs' ),
				'top-menu' => esc_html__( 'Top Menu', 'ecommerce-gigs' ),
				'social-media' => esc_html__( 'Social Menu', 'ecommerce-gigs' ),
				'vertical-menu' => esc_html__( 'Vertical Menu', 'ecommerce-gigs' ),
				'beside-menu' => esc_html__( 'Beside Menu', 'ecommerce-gigs' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);
		// Set up the WordPress core custom background feature.
		add_theme_support('custom-background', apply_filters( 'ecommerce_gigs_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support('custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'ecommerce_gigs_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ecommerce_gigs_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'ecommerce_gigs_content_width', 640 );
}
add_action( 'after_setup_theme', 'ecommerce_gigs_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ecommerce_gigs_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'ecommerce-gigs' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'ecommerce-gigs' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Woocommerce Sidebar', 'ecommerce-gigs' ),
			'id'            => 'sidebar-woo',
			'description'   => esc_html__( 'Add widgets here.', 'ecommerce-gigs' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);	
	register_sidebar(
		array(
			'name'          => esc_html__( 'Home Content', 'ecommerce-gigs' ),
			'id'            => 'featured-slider-widget',
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);		
	register_sidebar(
		array(
			'name'          => esc_html__( 'Subscribe Widget', 'ecommerce-gigs' ),
			'id'            => 'subscribe-widget',
			'before_widget' => '<section id="%1$s" class="widget subscribe-form-wrapper %2$s"><div class="container">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	for ( $i = 1; $i <= 4 ; $i++ ) {
		register_sidebar( array(
			'name'          => sprintf( esc_html__('Top Footer Widget %d', 'ecommerce-gigs'), absint( $i ) ),
			'id'            => 'top-footer-widget-' . absint( $i ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}		
	for ( $i = 1; $i <= 4 ; $i++ ) {
		register_sidebar( array(
			'name'          => sprintf( esc_html__('Footer %d', 'ecommerce-gigs'), absint( $i ) ),
			'id'            => 'footer-' . absint( $i ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}	
}
add_action( 'widgets_init', 'ecommerce_gigs_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ecommerce_gigs_scripts() {
	wp_enqueue_style( 'ecommerce-gigs-fonts', ecommerce_gigs_fonts_url(), array(), null );

	wp_enqueue_style( 'font-awesome-min-css', get_template_directory_uri() .'/assets/css/font-awesome.min.css', array(), '4.7.0' );

	wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/assets/css/owl.theme.css',array(), 'v2.2.0' );

	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css',array(), 'v2.2.0' );

	wp_enqueue_style( 'meanmenu', get_template_directory_uri().'/assets/css/meanmenu.css', array(), '2.0.7' );

	wp_enqueue_style( 'ecommerce-gigs-style', get_stylesheet_uri(), array(), ECOMMERCE_GIGS_VERSION );

	wp_enqueue_style( 'ecommerce-gigs-responsive', get_template_directory_uri().'/assets/css/responsive.css', array(), ECOMMERCE_GIGS_VERSION );

	wp_style_add_data( 'ecommerce-gigs-style', 'rtl', 'replace' );

	wp_enqueue_style( 'ecommerce-gigs-responsive', get_template_directory_uri() . '/assets/css/responsive.css',array(), ECOMMERCE_GIGS_VERSION );

	wp_enqueue_script( 'theia-sticky-sidebar-js', get_template_directory_uri() .'/assets/js/theia-sticky-sidebar.min.js', array(), 'v1.7.0', true );	

	wp_enqueue_script( 'jquery-meanmenu', get_template_directory_uri() . '/assets/js/jquery.meanmenu.js', array( 'jquery'), 'v2.0.8', true );

	wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.js', array( 'jquery'), 'v2.0.8', true );

	wp_enqueue_script( 'ecommerce-gigs-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), ECOMMERCE_GIGS_VERSION, true );

	wp_enqueue_script( 'ecommerce-gigs-custom', get_template_directory_uri() . '/assets/js/custom.js', array(), ECOMMERCE_GIGS_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ecommerce_gigs_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme 
 */
require get_template_directory() . '/inc/extra-functions.php';

/**
 * Functions which enhance the theme 
 */
require get_template_directory() . '/inc/hook.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Widget Init.
 */
require trailingslashit( get_template_directory() ). '/inc/widget/widget-init.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Include default theme options.
 */
require_once trailingslashit( get_template_directory() ) . 'inc/customizer/default.php';

/**
 * Add Meta Box.
 */
require trailingslashit( get_template_directory() ) . '/inc/metabox.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

// Install Recommed Plugin
require trailingslashit( get_template_directory() ) . '/inc/class-tgm-plugin-activation.php';
