<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Ecommerce_Gigs
 */

get_header();
?>

	<main id="primary" class="site-main">
			<section class="error-404 not-found" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/assets/img/error-bg.jpg);">
			<div class="not-found-content-wrap">
				<h2 class="page-title"><?php esc_html_e( '404', 'ecommerce-gigs' ); ?> </h2>
					<p class="entry-title"><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'ecommerce-gigs' ); ?></p>
					<?php get_search_form(); ?>                
				<a class="button" href="<?php echo esc_url(home_url( '/' ) ); ?>">
					<?php echo esc_html__( 'BACK TO HOMEPAGE', 'ecommerce-gigs' );?>
				</a>
				</div>
			</section><!-- .error-404 -->
	</main><!-- #main -->

<?php
get_footer();
