<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package eco_store
 */
$eco_store_heading_setting  = get_theme_mod( 'eco_store_post_heading_setting' , true );
$eco_store_meta_setting  = get_theme_mod( 'eco_store_post_meta_setting' , true );
$eco_store_image_setting  = get_theme_mod( 'eco_store_post_image_setting' , true );
$eco_store_content_setting  = get_theme_mod( 'eco_store_post_content_setting' , true );
$eco_store_read_more_setting = get_theme_mod( 'eco_store_read_more_setting' , true );
$eco_store_read_more_text = get_theme_mod( 'eco_store_read_more_text', __( 'Read More', 'eco-store' ) );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		  if ( $eco_store_heading_setting ){ 
			if ( is_single() ) {
				the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' );
			} else {
				the_title( '<h2 class="entry-title" itemprop="headline"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			}
		  }

		if ( 'post' === get_post_type() ) : ?>
		<?php
		if ( $eco_store_meta_setting ){ ?>
			<div class="entry-meta">
				<?php eco_store_posted_on(); ?>
			</div><!-- .entry-meta -->
		<?php } ?>
		<?php
		endif; ?>
	</header><!-- .entry-header -->
	<?php if ( $eco_store_image_setting ) { ?>
		<?php echo ( ! is_single() ) ? '<a href="' . esc_url( get_the_permalink() ) . '" class="post-thumbnail">' : '<div class="post-thumbnail">'; ?>

			<?php if ( has_post_thumbnail() ) {
				// Load thumbnail depending on sidebar
				if ( is_active_sidebar( 'right-sidebar' ) ) {
					the_post_thumbnail( 'eco-store-with-sidebar', array( 'itemprop' => 'image' ) );
				} else {
					the_post_thumbnail( 'eco-store-without-sidebar', array( 'itemprop' => 'image' ) );
				}
			} else {
				// Load default image
				$eco_store_default_img_url = get_template_directory_uri() . '/images/default-header.png'; 
				$eco_store_image_class = is_active_sidebar( 'right-sidebar' ) ? 'eco-store-with-sidebar' : 'eco-store-without-sidebar';
				echo '<img src="' . esc_url( $eco_store_default_img_url ) . '" class="' . esc_attr( $eco_store_image_class ) . '" alt="' . esc_attr__( 'Default Image', 'eco-store' ) . '" itemprop="image" />';
			} ?>

		<?php echo ( ! is_single() ) ? '</a>' : '</div>'; ?>
	<?php } ?>

    <?php
	if ( $eco_store_content_setting ){ ?>
		<div class="entry-content" itemprop="text">
			<?php
			if( is_single()){
				the_content( sprintf(
					/* translators: %s: Name of current post. */
					wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'eco-store' ), array( 'span' => array( 'class' => array() ) ) ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );
				}else{
				the_excerpt();
				}
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'eco-store' ),
					'after'  => '</div>',
				) );
			?>
		</div><!-- .entry-content -->
    <?php } ?>
    <?php if ( !is_single() && $eco_store_read_more_setting ) { ?>
        <div class="read-more-button">
            <a href="<?php echo esc_url( get_permalink() ); ?>" class="read-more-button"><?php echo esc_html( $eco_store_read_more_text ); ?></a>
        </div>
    <?php } ?>
</article><!-- #post-## -->