<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Eco Store
 */

$eco_store_classes      = get_theme_mod( 'eco_store_classes_setting', false );
$eco_store_service_title = get_theme_mod( 'eco_store_service_title' );
$eco_store_service_text  = get_theme_mod( 'eco_store_service_text' );
?>

<?php if ( $eco_store_classes ) : ?>
    <div class="our-classes">
        <div class="container">
            <div class="side-border">
                <?php if ( $eco_store_service_title ) : ?>
                    <h6 class="mb-3"><?php echo esc_html( $eco_store_service_title ); ?></h6>
                <?php endif; ?>

                <?php if ( $eco_store_service_text ) : ?>
                    <h3 class="title-text"><?php echo esc_html( $eco_store_service_text ); ?></h3>
                <?php endif; ?>
            </div>
            <div class="owl-carousel">
                <?php 
                $eco_store_catergory_name = get_theme_mod( 'eco_store_blog_args_' );
                $args = array(
                    'post_type'           => 'post',
                    'category_name'       => $eco_store_catergory_name,
                    'orderby'             => 'post__in',
                    'ignore_sticky_posts' => true,
                );

                $loop = new WP_Query( $args );
                if ( $loop->have_posts() ) :
                    $eco_store_i = 1;
                    while ( $loop->have_posts() ) : $loop->the_post(); ?>
                        <div class="box">
                            <div class="box-content">

                                <?php if ( get_theme_mod( 'eco_store_category_icon' . $eco_store_i ) != '' ) : ?>
                                    <span><i class="<?php echo esc_attr( get_theme_mod( 'eco_store_category_icon' . $eco_store_i ) ); ?>"></i></span>
                                <?php endif; ?>

                                <h4 class="title mb-2 mt-3">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h4>
                                <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 15 ); ?></p>
                                <p class="sign-in-area mt-3">
                                    <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Read More', 'eco-store'); ?>
                                    </a>
                                </p>
                            </div>
                        </div>
                    <?php 
                    $eco_store_i++;
                    endwhile;
                endif;
                ?>
            </div>
        </div>
    </div>
<?php endif; ?>