<?php
/**
 * Banner Section
 * 
 * @package eco_store
 */
$eco_store_slider = get_theme_mod( 'eco_store_slider_setting',false );
$eco_store_contact = get_theme_mod( 'eco_store_contact_setting',false );
$eco_store_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('eco_store_blog_slide_category'),
  'posts_per_page' => 3,
); ?>
<?php
  $eco_store_header_email = get_theme_mod('eco_store_header_email');
  $eco_store_address = get_theme_mod('eco_store_address');
  $eco_store_header_phone = get_theme_mod('eco_store_header_phone');
?>
<?php if ( $eco_store_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $eco_store_arr_posts = new WP_Query( $eco_store_args );
      if ( $eco_store_arr_posts->have_posts() ) :
        while ( $eco_store_arr_posts->have_posts() ) :
          $eco_store_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="banner_inner_box">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/slide.png'; ?>">
                </div>
                <?php
              endif;
            ?>
            <div class="banner_box">
              <div class="container">
                <?php if ( get_theme_mod('eco_store_slider_text_extra') ) : ?>
                    <p class="slide-extra-head"><?php echo esc_html(get_theme_mod('eco_store_slider_text_extra')); ?></p>
                <?php endif; ?>
                <h3 class="my-2"><?php the_title(); ?></h3>
                <p class="mb-0 content"><?php echo wp_trim_words( get_the_content(), 20 ); ?></p>
                <div class="slide-btns">
                  <p class="btn-green mt-4">
                    <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Read More','eco-store'); ?></a>
                  </p>               
                </div>
              </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>
<?php if ( $eco_store_contact ){?>
  <div class="contact-section">
    <div class="container row m-auto">    
      <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 align-self-center">
        <?php if ( $eco_store_header_email ){?>
            <div class="location">
                <span class="contact-icon">
                    <i class="fas fa-envelope-open-text"></i>
                </span>
                <span class="contact-box">
                    <p class="contact-heading"><?php echo esc_html('Mail Us','eco-store' );?></p>
                    <span class="location-text">
                        <a href="mailto:<?php echo esc_attr($eco_store_header_email);?>">
                            <?php echo esc_html($eco_store_header_email);?>
                        </a>
                    </span>
                </span>              
            </div>
        <?php } ?>
      </div>
      <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12 align-self-center">
        <?php if ( $eco_store_address ){?>
            <div class="location contact-location">
                <span class="contact-icon">
                    <i class="fas fa-map-marker-alt"></i>
                </span>
                <span class="contact-box">
                    <p class="contact-heading"><?php echo esc_html('Location','eco-store' );?></p>
                        <a class="location-text" href="https://www.google.com/maps/search/?api=1&query=<?php echo urlencode($eco_store_address); ?>" target="_blank" rel="noopener">
                          <?php echo esc_html($eco_store_address); ?>
                        </a>
                </span>
            </div>
        <?php } ?>     
      </div>
      <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12 align-self-center contact-num">
        <?php if ( $eco_store_header_phone ){?>
            <div class="location contact-number">
                <span class="contact-icon">
                    <i class="fas fa-phone"></i>
                </span>
                <span class="contact-box">
                    <p class="contact-heading"><?php echo esc_html('Contact Us Any Time?','eco-store' );?></p>
                      <span class="location-text">
                        <a href="tel:<?php echo esc_attr($eco_store_header_phone);?>">
                            <?php echo esc_html( $eco_store_header_phone);?>
                        </a>
                    </span>
                </span>
            </div>
        <?php } ?>
      </div>
    </div>
  </div>
<?php } ?>
  