<?php
/**
 * Help Panel.
 *
 * @package Eco_Store
 */
?>

<div id="help-panel" class="panel-left visible">

    <div class="panel-aside active">
        <h4><?php printf( esc_html__( ' DEMO CONTENT IMPORTER', 'eco-store' )); ?></h4>
        <p><?php esc_html_e( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'eco-store' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url(admin_url('themes.php?page=ecostore-wizard')); ?>" title="<?php esc_attr_e( 'Demo Importer', 'eco-store' ); ?>" target="_blank">
            <?php esc_html_e( 'DEMO IMPORTER', 'eco-store' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php printf( esc_html__( ' VISIT FREE DOCUMENTATION', 'eco-store' )); ?></h4>
        <p><?php esc_html_e( 'Are you a newcomer to the WordPress universe? Our comprehensive and user-friendly documentation guide is designed to assist you in effortlessly building a captivating and interactive website, even if you lack any coding expertise or prior experience. Follow our step-by-step instructions to create a visually appealing and engaging online presence.', 'eco-store' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ECO_STORE_FREE_DOC_URL ); ?>" title="<?php esc_attr_e( 'Visit the Documentation', 'eco-store' ); ?>" target="_blank">
            <?php esc_html_e( 'FREE DOCUMENTATION', 'eco-store' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php esc_html_e( 'REVIEW', 'eco-store' ); ?></h4>
        <p><?php esc_html_e( 'If you are passionate about the Eco Store theme, we would love to hear your thoughts and feedback regarding our theme. Your review will be highly valuable to us as we strive to enhance and improve our theme based on the needs and preferences of our users. Your opinion matters, and we sincerely appreciate your time and effort in sharing your experience with the Eco Store theme.', 'eco-store' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ECO_STORE_REVIEW_URL ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'eco-store' ); ?>" target="_blank">
            <?php esc_html_e( 'REVIEW', 'eco-store' ); ?>
        </a>
    </div>
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'CONTACT SUPPORT', 'eco-store' ); ?></h4>
        <p>
            <?php esc_html_e( 'Thank you for choosing Eco Store! We appreciate your interest in our theme and are here to assist you with any support you may need.', 'eco-store' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ECO_STORE_SUPPORT_URL ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'eco-store' ); ?>" target="_blank">
            <?php esc_html_e( 'CONTACT SUPPORT', 'eco-store' ); ?>
        </a>
    </div>
</div>